package com.xforceplus.taxware.leqi.kernel.contract.model.supervision.alert;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import com.xforceplus.taxware.leqi.kernel.contract.model.unit.PostUseUnitAccessStatusMessage;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author lvwenjing
 * @date 2024/12/26
 * @describe: 反馈使用单位红色预警检测结果
 */
public class PostUseUnitRedAlertBatchResultMessage {

    @Data
    public static class Request {

        /**
         * 批次流水号 String 32
         * 使用单位红色预警检测（测量）接口返回的批次流水号
         */
        @JSONField(name = "pclsh")
        private String taskId;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 批次流水号 String 32
         * 成功时，返回批次流水号，直连单位可以通过批次流水号查询资格预检结果
         * 失败时，不返回，直连单位可重新发起批量预检查询
         */
        @JSONField(name = "pclsh")
        private String taskId;

        /**
         * 业务类型 是
         * 红色预警-日常检测服务 HSYJ003
         * 红色预警-开具发票阻断 HSYJ002  ok
         */
        @JSONField(name = "ywlx")
        private String businessType;

        /**
         * 查询结果
         */
        @JSONField(name = "cxjg")
        private List<RedAlertResult> redAlertResultList;

        @Data
        public static class RedAlertResult {

            /**
             * 纳税人识别号 是
             */
            @JSONField(name = "nsrsbh")
            private String taxNo;

            /**
             * 纳税人名称 否
             */
            @JSONField(name = "nsrmc")
            private String taxpayerName;
            /**
             * 主管税务机关名称
             * 是
             */
            @JSONField(name = "zgswjgmc")
            private String chargeTaxAuthorityName;

            /**
             * 红色预警标志 String 1 是 Y：是，存在红色预警 N：否
             */
            @JSONField(name = "hsyjbz")
            private String redAlertFlag;
            /**
             * 成功标志
             * 0查询纳税人成功
             * 1查询纳税人不存在：输入的纳税人识别号在税务系统未查询到有效税务登记信息时返回。
             */
            @JSONField(name = "cgbz")
            private String successFlag;
        }
    }
}
