package com.xforceplus.taxware.leqi.kernel.contract.model.unit;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author lvwenjing
 * @date 2023/7/22
 * @describe: 查询开票人员登记确认状态接口
 */
public class PostUseUnitIssuerRegistStatusMessage {

    @Data
    public static class Request {

        /**
         * 纳税人识别号/统一社会信用代码 是
         */
        @JSONField(name = "sydwshxydm")
        private String taxNo;

        /**
         * 省级税务机关代码 是
         */
        @JSONField(name = "ssjswjgDm")
        private String provincialTaxAuthorityCode;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 纳税人识别号/统一社会信用代码 20
         * 是
         */
        @JSONField(name = "sydwshxydm")
        private String taxNo;

        /**
         * 使用单位纳税人 名称 300
         * 是
         */
        @JSONField(name = "sydwnsrmc")
        private String taxpayerName;

        /**
         * 省市级税务机关 代码
         * 20
         * 是
         */
        @JSONField(name = "ssjswjgDm")
        private String provincialTaxAuthorityCode;

        /**
         * 开票人员信息记 录数
         * 是
         */
        @JSONField(name = "kpysl")
        private Integer issuerTotal;

        /**
         * 开票人员信息
         * 是
         */
        @JSONField(name = "kpyxx")
        private List<Issuer> issuerList;

        @Data
        public static class Issuer {

            /**
             * 开票人员名称
             * 300
             * 是
             */
            @JSONField(name = "kpyxm")
            private String issuer;

            /**
             * 开票人证件号码（必须）
             * 20
             */
            @JSONField(name = "kpyzjhm")
            private String issuerIdentityNo;

            /**
             * 开票人证件类型（必须）
             * 4
             */
            @JSONField(name = "kpyzjlx")
            private String issuerIdentityType;

            /**
             * 邀请时间 时间格 式:”yyyy-MM -dd HH:mm:ss ”
             */
            @JSONField(name = "yqsj")
            private String inviteTime;

            /**
             * 确认时间 时间格 式:”yyyy-MM -dd HH:mm:ss ”
             */
            @JSONField(name = "qrsj")
            private String confirmTime;

            /**
             * 解除时间 时间格 式:”yyyy-MM -dd HH:mm:ss ”
             */
            @JSONField(name = "jcsj")
            private String dissolveTime;

            /**
             * 开票人员确认状 态
             * 2
             * 是
             *
             */
            @JSONField(name = "djzt")
            private String confirmStatus;
        }
    }
}
