package com.xforceplus.taxware.leqi.kernel.contract.model.unit;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author lvwenjing
 * @date 2023/7/22
 * @describe: 查询使用单位乐企白名单开通状态
 */
public class PostUseUnitWhitelistOpenStatusMessage {

    @Data
    public static class Request {

        /**
         * 使用单位纳税人税号 否
         */
        @JSONField(name = "sydwshxydm")
        private String taxNo;

        /**
         * 使用单位纳税人名称 否
         */
        @JSONField(name = "sydwnsrmc")
        private String taxpayerName;

        /**
         * 页码（必须）
         */
        @JSONField(name = "pageNumber")
        private Integer pageNumber = 1;

        /**
         * 每页数量（必须）
         */
        @JSONField(name = "pageSize")
        private Integer pageSize = 20;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 页码（必须）
         */
        @JSONField(name = "pageNumber")
        private Integer pageNumber;

        /**
         * 每页数量（必须）
         */
        @JSONField(name = "pageSize")
        private Integer pageSize;

        /**
         * 总记录数
         * 是
         * 10
         */
        @JSONField(name = "total")
        private Integer total;

        /**
         * 乐企白名单明细
         * 否
         */
        @JSONField(name = "lqbmdmx")
        private List<NsUnit> nsUnitList;

        @Data
        public static class NsUnit {
            /**
             * 使用单位登记序 号 20
             * 是
             */
            @JSONField(name = "sydwdjxh")
            private String registerNo;

            /**
             * 使用单位纳税人 识别号/统一社会 信用代码 20
             * 是
             */
            @JSONField(name = "sydwshxydm")
            private String taxNo;

            /**
             * 使用单位纳税人 名称 300
             * 是
             */
            @JSONField(name = "sydwnsrmc")
            private String taxpayerName;

            /**
             * 状态 2:未维护 1:启用
             * 是
             */
            @JSONField(name = "zt")
            private String status;

            /**
             * 录入日期
             * yyyy-MM-dd HH:mm:ss
             * 否
             * 19
             */
            @JSONField(name = "lrrq")
            private String applyDate;
        }
    }
}
