/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.leqi.kernel.contract.model.enums;

import java.util.Arrays;
import java.util.Objects;

public enum NaturalSystemEnums {
    TAXPAYER_INFO("taxpayerInfo", "CXNSRJBXX"),
    TAXPAYER_RISK_INFO("taxpayerRisk", "CXNSRFXXX"),
    TAX_RATE_INFO("taxRate", "CXKYSL"),
    TAX_CODE_INFO("taxCode", "CXSSFLBM"),
    DIFFERENCE_TAX_CODE_INFO("differenceTaxCode", "CXCEZSBM"),
    CREDIT_LINE("creditLine", "CXSXED"),
    DOWNLOAD_CREDIT_LINE("downloadSendBackCreditLine", "XZTHSXED"),
    CREDIT_LINE_PERIOD("creditLinePeriod", "TZSXEDYXQ"),
    INVOICE_NO_SEGMENT("invoiceNoSegment", "QDFPPLFM"),
    INVOICE_UPLOAD("invoiceUpload", "QDFPSC"),
    INVOICE_UPLOAD_RESULT("invoiceUploadResult", "CXQDFPSCJG"),
    INVOICE_UPLOAD_OIL("invoiceUploadOil", "QDFPSC_CPY"),
    INVOICE_UPLOAD_OIL_RESULT("invoiceUploadOilResult", "CXQDFPSCJG_CPY"),
    INVOICE_UPLOAD_FREIGHT("invoiceUploadFreight", "HWYSFPSC"),
    INVOICE_UPLOAD_ESTATE_LEASE("invoiceUploadEstateLease", "BDCJYZLFPSC"),
    INVOICE_UPLOAD_ESTATE_SALES("invoiceUploadEstateSales", "QDFPSC_BDCXS"),
    INVOICE_UPLOAD_PRODUCE_PURCHASE("invoiceUploadProducePurchase", "NCPSGFPSC"),
    INVOICE_UPLOAD_PRODUCE_SALES("invoiceUploadProduceSales", "NCPXSFPSC"),
    INVOICE_UPLOAD_BUILDING_SERVICE_INFO("invoiceUploadBuildingServiceInfo", "QDFPSC_JZFW"),
    RED_LETTER_APPLY("redLetterApply", "QDHZQRDSQ"),
    RED_LETTER_CONFIRM("redLetterConfirm", "QDHZQRDQR"),
    RED_LETTER_LIST("redLetterList", "CXQDHZQRDLB"),
    RED_LETTER_DETAIL("redLetterDetail", "CXQDHZQRDMX"),
    INVOICE_SUMMARY_UPLOAD("invoiceSummaryUpload", "SCFPHZQRXX"),
    INVOICE_SUMMARY_QUERY("invoiceSummaryQuery", "CXFPHZQRXX"),
    INVOICE_PURPOSE_STATUS_FOR_MAKE("invoicePurposeStatusForMake", "FPZTXXCX"),
    OIL_TAX_CODE_INFO("oilTaxCode", "CXCPYKYSSFLBM"),
    OIL_INVENTORY("oilInventory", "CXCPYKC"),
    DOWNLOAD_OIL_INVENTORY("oilInventoryDownloadSendBack", "XZHTHCPYKC"),
    PROPERTY_INFO("propertyInfo", "CXFYXX"),
    BUILDING_SERVICE_INFO("buildingServiceInfo", "CXJZFWXX"),
    JEWELRY_PILOT("jewelryPilot", "CXGFSFWSDDQQY"),
    JEWELRY_QUALIFICATION("jewelryQualification", "CXJYSSJYQYZG"),
    INVOICE_UPLOAD_JEWELRY("invoiceUploadJewelry", "JYSSFPSC"),
    INVOICE_XML("invoiceXml", "FPWJSQXZ"),
    INVOICE_XML_RESULT("invoiceXmlResult", "FPWJSQJGFK"),
    INVOICE_RISK_STATUS("invoiceRiskStatus", "FPTSTXXXCX"),
    INVOICE_PURPOSE_STATUS("invoicePurposeStatus", "FPZTXXCX"),
    INVOICE_DOWNLOAD("invoiceDownload", "PLFPXZSQ"),
    INVOICE_DOWNLOAD_RESULT("invoiceDownloadResult", "PLFPXZSQFK"),
    INVOICE_DOWNLOAD_INCREMENT("invoiceDownloadIncrement", "CXZLXZFPXX"),
    EXPORT_TO_DOMESTIC_SALES_INVOICE("exportToDomesticSalesInvoice", "PLCKZNXFPXXCX"),
    EXPORT_TO_DOMESTIC_SALES_CUSTOMS_PAYMENT("exportToDomesticSalesCustomsPayment", "PLCKZNXHGJKSXXCX"),
    VAT_TAX_PAYMENT_VOUNCHER("vatTaxPaymentVoucher", "PLZZSDKDJWSPZXZSQ"),
    VAT_TAX_PAYMENT_VOUNCHER_RESULT("vatTaxPaymentVoucherResult", "PLZZSDKDJWSPZXZSQFK"),
    VAT_TAX_PAYMENT_VOUNCHER_INCREMENT("vatTaxPaymentVoucherIncrement", "CXZLXZZZSDKDJWSPZXX"),
    EXCISE_TAX_PAYMENT_VOUCHER("exciseTaxPaymentVoucher", "PLXFSDKDJWSPZXZSQ"),
    EXCISE_TAX_PAYMENT_VOUCHER_RESULT("exciseTaxPaymentVoucherResult", "PLXFSDKDJWSPZXZSQFK"),
    EXCISE_TAX_PAYMENT_VOUCHER_INCREMENT("exciseTaxPaymentVoucherIncrement", "CXZLXZXFSDKDJWSPZXX"),
    CUSTOMS_PAYMENT("customsPayment", "PLHGJKSXZSQ"),
    CUSTOMS_PAYMENT_RESULT("customsPaymentResult", "PLHGJKSXZSQFK"),
    CUSTOMS_PAYMENT_INCREMENT("customsPaymentIncrement", "CXZLXZHGJKSXX"),
    TAX_PERIOD("taxPeriod", "HQDQSKSSQYDQSKSSQTJZT"),
    INVOICE_DEDUCTION_UPLOAD("invoiceDeductionUpload", "PLFPDKGX"),
    INVOICE_DEDUCTION_UPLOAD_RESULT("invoiceDeductionUploadResult", "CXFPDKGXCLJG"),
    CUSTOMS_PAYMENT_DEDUCTION_UPLOAD("customsPaymentDeductionUpload", "PLHGJKSDKGX"),
    CUSTOMS_PAYMENT_DEDUCTION_UPLOAD_RESULT("customsPaymentDeductionUploadResult", "CXHGJKSDKGXCLJG"),
    DEDUCTION_STATISTICS_APPLY("deductionStatisticsApply", "SQCXDKTJ"),
    DEDUCTION_STATISTICS_APPLY_RESULT("deductionStatisticsApplyResult", "CXTJCLJG"),
    DEDUCTION_STATISTICS_CONFIRM_APPLY("deductionStatisticsConfirmApply", "SQQRDKTJ"),
    DEDUCTION_STATISTICS_CONFIRM_APPLY_RESULT("deductionStatisticsConfirmApplyResult", "CXQRTJCLJG"),
    CURRENT_TAX_PERIOD_INVOICE_DEDUCTION("currentTaxPeriodInvoiceDeduction", "HQDQSKSSQFPDKGXCLJG"),
    CURRENT_TAX_PERIOD_CUSTOMS_PAYMENT_DEDUCTION("currentTaxPeriodCustomsPaymentDeduction", "HQDQSKSSQHGJKSDKGXCLJG"),
    VAT_TAX_PAYMENT_VOUCHER_DEDUCTION_UPLOAD("vatTaxPaymentVoucherDeductionUpload", "PLSCZZSDKDJWSPZDKGX"),
    VAT_TAX_PAYMENT_VOUCHER_DEDUCTION_UPLOAD_RESULT("vatTaxPaymentVoucherDeductionUploadResult", "CXZZSDKDJWSPZDKGXCLJG"),
    CURRENT_VAT_TAX_PAYMENT_VOUCHER_DEDUCTION("currentVatTaxPaymentVoucherDeduction", "HQDQSKSSQDKDJWSPZDKGXCLJG"),
    DEDUCTION_UNCHECK_INIT("deductionUncheckInit", "WGXSJCSHQDXZSQDKGX"),
    DEDUCTION_UNCHECK_INIT_RESULT("deductionUncheckInitResult", "WGXSJCSHQDXZSQFKDKGX"),
    INVOICE_AGRICULTURAL_PRODUCTS_TO_BE_PROCESSED_UPLOAD("invoiceAgriculturalProductsToBeProcessedUpload", "PLSCDCLNCPFPQRQD"),
    INVOICE_AGRICULTRUAL_PRODUCTS_TO_BE_PROCESSED_UPLOAD_RESULT("invoiceAgriculturalProductsToBeProcessedUploadResult", "CXPLSCDCLNCPFPQRQDCLJG"),
    INVOICE_AGRICULTURAL_PRODUCTS_DEPUTY_UPLOAD("invoiceAgriculturalProductsDeputyUpload", "PLSCSWJGDKNCPFPBLXX"),
    INVOICE_AGRICULTRUAL_PRODUCTS_DEPUTY_UPLOAD_RESULT("invoiceAgriculturalProductsDeputyUploadResult", "CXPLSCSWJGDKNCPFPBLXXCLJG"),
    INVOICE_AGRICULTURAL_PRODUCTS_TAX_CODE("invoiceAgriculturalProductsTaxCode", "CXFPNCPSPBMLB"),
    SUMMARY_TAXPAYER("summaryTaxpayer", "HZNSRJGLBCX"),
    SUMMARY_CONFIRM("summaryConfirm", "ZFJGHZGXQR"),
    TAX_PERIOD_CHANGE("taxPeriodChange", "SQSKSSQBG"),
    CANCLE_CHECK("cancelCheck", "SQZXGX"),
    INVOICE_TAX_REFUND_UPLOAD("invoiceTaxRefundUpload", "PLFPTSGXQR"),
    INVOICE_TAX_REFUND_UPLOAD_RESULT("invoiceTaxRefundUploadResult", "CXFPTSGXQRCLJG"),
    CUSTOMS_PAYMENT_TAX_REFUND_UPLOAD("customsPaymentTaxRefundUpload", "PLHGJKSTSGXQR"),
    CUSTOMS_PAYMENT_TAX_REFUND_UPLOAD_RESULT("customsPaymentTaxRefundUploadResult", "CXHGJKSTSGXQRCLJG"),
    TAX_REFUND_UNCHECK_INIT("taxRefundUncheckInit", "WGXSJCSHQDXZSQTSGX"),
    TAX_REFUND_UNCHECK_INIT_RESULT("taxRefundUncheckInitResult", "WGXSJCSHQDXZSQFKTSGX"),
    INVOICE_DEPUTY_TAX_REFUND_UPLOAD("invoiceDeputyTaxRefundUpload", "PLFPDBGX"),
    INVOICE_DEPUTY_TAX_REFUND_UPLOAD_RESULT("invoiceDeputyTaxRefundUploadResult", "CXDBTSGX"),
    DEPUTY_TAX_REFUND_UNCHECK_INIT("deputyTaxRefundUncheckInit", "WGXSJCSHQDXZSQDBTSGX"),
    DEPUTY_TAX_REFUND_UNCHECK_INIT_RESULT("deputyTaxRefundUncheckInitResult", "WGXSJCSHQDXZSQFKDBTSGX"),
    INVOICE_VERIFY("invoiceVerify", "FPCY_NEW"),
    INVOICE_ENTRY_UPLOAD("invoiceEntryUpload", "PLSCRZFP"),
    INVOICE_ENTRY_UPLOAD_RESULT("invoiceEntryUploadResult", "CXFPRZCLJG"),
    VAT_TAX_PAYMENT_VOUCHER_ENTRY_UPLOAD("vatTaxPaymentVoucherEntryUpload", "PLSCRZDKDJWSPZ"),
    VAT_TAX_PAYMENT_VOUCHER_ENTRY_UPLOAD_RESULT("vatTaxPaymentVoucherEntryUploadResult", "CXDKDJWSPZRZCLJG"),
    CUSTOMS_PAYMENT_ENTRY_UPLOAD("customsPaymentEntryUpload", "PLSCRZHGJKS"),
    CUSTOMS_PAYMENT_ENTRY_UPLOAD_RESULT("customsPaymentEntryUploadResult", "CXHGJKSRZCLJG"),
    GET_QR_CODE("getQRCode", "/access/v1/getQRCode"),
    GET_AUTH_CODE("getAuthCode", "/access/v1/getAuthCode"),
    GET_TOKEN("getToken", "/access/v1/getToken"),
    SANDBOX_CONTROL("sandboxControl", "/access/sandbox_kzfw/v1/%s"),
    USE_UNIT_WHITELIST_OPEN_STATUS("useUnitWhitelistOpenStatus", "CXSYDWLQBMDKTZT"),
    USE_UNIT_ISSUER_REGIST_STATUS("useUnitIssuerRegistStatus", "CXKPRYDJQRZT"),
    USE_UNIT_ACCESS_STATUS("useUnitAccessStatus", "CXSYDWJRZT"),
    USE_UNIT_AUTH_INFO("useUnitAuthInfo", "CXSYDWSQRZXX"),
    USE_UNIT_APPLY("useUnitApply", "SYDWSQ"),
    INDEX_UPLOAD("indexUpload", "SCZBSMJG"),
    INDEX_UPLOAD_RESULT("indexUploadResult", "CXSCJG"),
    USE_UNIT_RED_ALERT("useUnitRedAlert", "SYDWHSYJJCDH"),
    USE_UNIT_RED_ALERT_BATCH("useUnitRedAlertBatch", "SYDWHSYJJCPL"),
    USE_UNIT_RED_ALERT_BATCH_RESULT("useUnitRedAlertBatchResult", "FKSYDWHSYJJCJG");

    private final String name;
    private final String serviceCode;

    private NaturalSystemEnums(String name, String serviceCode) {
        this.name = name;
        this.serviceCode = serviceCode;
    }

    public static NaturalSystemEnums fromServiceCode(String serviceCode) {
        NaturalSystemEnums[] values = NaturalSystemEnums.values();
        return Arrays.stream(values).filter(naturalSystemEnums -> Objects.equals(serviceCode, naturalSystemEnums.serviceCode)).findFirst().orElse(null);
    }

    public static NaturalSystemEnums fromServiceName(String name) {
        NaturalSystemEnums[] values = NaturalSystemEnums.values();
        return Arrays.stream(values).filter(naturalSystemEnums -> Objects.equals(name, naturalSystemEnums.name)).findFirst().orElse(null);
    }

    public String getName() {
        return this.name;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }
}

