package com.xforceplus.taxware.leqi.kernel.contract.model.base.voucher;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.buyer.entry.PostInvoiceEntryUploadResult;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Auther lv
 * @Date 2023/11/15
 * @Description 消费税代扣代缴完税凭证数据
 */
@Data
public class ExciseTaxPaymentVoucher {

    /**
     * 代扣代缴完税凭证号
     * 必填
     */
    @JSONField(name = "dkdjwspzh")
    private String taxPaidProof;

    /**
     * 扣缴义务人识别号
     * 长度：20
     */
    @JSONField(name = "kjywrsbh")
    private String taxNo;

    /**
     * 扣缴义务人名称
     * 长度：300
     */
    @JSONField(name = "kjywrmc")
    private String taxName;

    /**
     * 被扣缴纳税人识别号
     * 长度：20
     */
    @JSONField(name = "bkjnsrsbh")
    private String taxNoReal;

    /**
     * 被扣缴纳税人名称
     * 长度：300
     */
    @JSONField(name = "bkjnsrmc")
    private String taxNameReal;

    /**
     * 计税金额
     * DECIMAL：18,2
     */
    @JSONField(name = "jsje")
    private String amountWithoutTax;

    /**
     * 实缴金额
     * DECIMAL：18,2
     */
    @JSONField(name = "sjje")
    private String taxAmount;

    /**
     * 填发日期
     * 长度：19 YYYY-MM-DD HH:mm:ss
     */
    @JSONField(name = "tfrq")
    private String dateTimeIssued;

    /**
     * 开具日期
     * 长度：19 YYYY-MM-DD HH:mm:ss
     */
    @JSONField(name = "kjrq")
    private String dateTimeIssued2;

    @JSONField(name = "hwxx")
    private List<Detail> detailList;

    @Data
    public static class Detail {

        /**
         * 数量
         * 长度：25
         * 非必需
         */
        @JSONField(name = "sl")
        private String quantity;

        /**
         * 实缴金额
         * 必需
         */
        @JSONField(name = "sjje")
        private BigDecimal taxAmount;

        /**
         * 计税金额
         * 必需
         */
        @JSONField(name = "jsje")
        private BigDecimal amountWithoutTax;

        /**
         * 商品编码
         * 长度：45
         * 必需
         */
        @JSONField(name = "spbm")
        private String goodsTaxNo;
    }
}
