package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.deduction;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Auther lv
 * @Date 2023/8/1
 * @Description 批量上传待处理农产品发票确认清单
 */
public class PostInvoiceAgriculturalProductsToBeProcessedUpload {
    @Data
    public static class Request {
        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：30
         * 必填
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        /**
         * 农产品类型
         * 长度：2
         * 必填
         * 1：自产农产品销售发票
         * 2：从小规模处购进的
         * 3：农产品专票
         */
        @JSONField(name = "ncplx")
        private String agriculturalProductsType;

        /**
         * 勾选类型
         * 长度：2
         * 必需
         * 农产品类型为
         * 1：自产农产品销售发票时可填写
         * 13：属于自产
         * 14：不属于自产
         * 15：部分属于自产农产品类型为
         * 2：从小规模处购进的
         * 3：农产品专票时可填写
         * 16：按票面金额和基础扣除率
         * 17：按票面税额
         */
        @JSONField(name = "gxlxDm")
        private String deductionType;

        @JSONField(name = "fpmx")
        private List<Detail> detailList;

        @Data
        public static class Detail {
            /**
             * 开票日期
             * 长度：8
             * 格式: YYYYMMDD
             * 必填
             */
            @JSONField(name = "kprq")
            private String dateIssued;

            /**
             * 发票代码
             * 全电发票发票代码可为空
             * 长度：12
             * 非必填
             */
            @JSONField(name = "fpdm")
            private String invoiceCode;

            /**
             * 发票号码
             * 长度：20
             * 必填
             * 数字化电子发票，发票号码 20 位
             */
            @JSONField(name = "fphm")
            private String invoiceNo;

            /**
             * 出口转内销证明编号
             * 长度：30
             * 非必填
             * 如为出口转内销需上传转内销证明编号
             */
            @JSONField(name = "ckznxzmbh")
            private String exportToDomesticSalesCertificateNo;

            /**
             * 发票类型
             * 长度：2
             * 必填
             * 农产品类型为
             * 1：自产农产品销售发票时可填写
             * 04：增值税普通发票
             * 10：增值税电子普通发票农产品类型为
             * 2：从小规模处购进的
             * 3：农产品专票时可填写
             * 01：增值税专用发票
             * 08：增值税电子专用发票
             * 81：电子发票 （增值税专用 发票）
             * 85：纸质发票（增值税专用发票）
             * */
            @JSONField(name = "fplx")
            private String invoiceType;

            /**
             * 农产品部分金额
             * 长度：2
             * 非必填
             * 勾选类型代码为 15：部分属于自产时，必填其他情况为空
             */
            @JSONField(name = "ncpbfje")
            private BigDecimal agriculturalProductsAmountWithoutTax;
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 批次流水号
         * 长度：32
         * 非必填
         * 返回码不是 00：成功时，不返回
         */
        @JSONField(name = "pclsh")
        private String taskId;

        @JSONField(name = "fpmx")
        private List<Detail> details;

        @Data
        public static class Detail {
            /**
             * todo 开票日期文档长度为 19，格式为 YYYYMMDD，存疑
             * 开票日期
             * 长度：19
             * 格式: YYYYMMDD
             * 必填
             */
            @JSONField(name = "kprq")
            private String dateIssued;

            /**
             * 发票代码
             * 全电发票发票代码可为空
             * 长度：12
             * 非必填
             */
            @JSONField(name = "fpdm")
            private String invoiceCode;

            /**
             * 发票号码
             * 全电发票，发票号码20位
             * 长度：20
             * 必填
             */
            @JSONField(name = "fphm")
            private String invoiceNo;

            /**
             * 上传状态
             * 长度：2
             * 必需
             * 00：成功
             * 01：失败
             */
            @JSONField(name = "sczt")
            private String uploadStatus;

            /**
             * 错误码
             * 长度：2000
             * 非必须
             * 01：失败时记录失败原因
             */
            @JSONField(name = "errormsg")
            private String errorMsg;
        }
    }
}
