package com.xforceplus.taxware.leqi.kernel.contract.model.publish;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author lvwenjing
 * @date 2025/10/13
 * @describe: 能力文档发布情况查询
 */
public class PostCapabilityDocPublishInfoMessage {

    @Data
    public static class Request {

        /**
         * 能力编码 否
         */
        @JSONField(name = "nlbm")
        private String capabilityCode;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 能力文档发布情况列表
         */
        @JSONField(name = "nlwdfbqkList")
        private List<CapabilityDocVerionInfo> capabilityDocVerionInfoList;

        /**
         * 修改说明列表
         */
        @JSONField(name = "xgsmList")
        private List<ChangeDetail> changeDetailList;

        @Data
        public static class CapabilityDocVerionInfo {
            /**
             * nlbm 能力编码 varchar 6 是
             */
            @JSONField(name = "nlbm")
            private String capabilityCode;

            /**
             * nlmc 能力名称 varchar 450 是
             */
            @JSONField(name = "nlmc")
            private String capabilityName;

            /**
             * nlwdmc 能力文档名称 varchar 500 是
             */
            @JSONField(name = "nlwdmc")
            private String capabilityDocName;

            /**
             * nlwdbbh 能力文档版本号 varchar 100 是
             */
            @JSONField(name = "nlwdbbh")
            private String capabilityDocVersionNo;

            /**
             * fbsj 发布时间 varchar 19 是 YYYY-MM-DD HH:mm:ss
             */
            @JSONField(name = "fbsj")
            private String publishTime;
        }

        @Data
        public static class ChangeDetail {

            /**
             * xgzjbh 修改章节编号 varchar 300 是
             */
            @JSONField(name = "xgzjbh")
            private String chapterNumber;

            /**
             * xgnrms 修改内容描述 varchar  是
             */
            @JSONField(name = "xgnrms")
            private String remark;

            /**
             * xgsxrq 修改生效日期 varchar 10 是 YYYY-MM-DD
             */
            @JSONField(name = "xgsxrq")
            private String effectiveDate;
        }
    }
}
