package com.xforceplus.taxware.leqi.kernel.contract.model.seller;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author lv
 * @date 2023/10/8
 * @describe: 查询成品油可用税收分类编码信息
 */
public class PostOilTaxCodeMessage {

    @Data
    public static class Request {

        /**
         * 纳税人识别号/统一社会信用代码
         * 开票纳税人识别号/统一社会信用代码
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;

        /**
         * 省级税务机关代码
         */
        @JSONField(name = "sjswjgdm")
        private String provincialTaxAuthorityCode;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 总数量
         */
        @JSONField(name = "count")
        private Integer total;

        @JSONField(name = "resultList")
        private List<TaxCodeInfo> resultList;

        @Data
        public static class TaxCodeInfo {
            /**
             * 商品编码
             */
            @JSONField(name = "spbm")
            private String goodsTaxNo;

            /**
             * 商品名称
             */
            @JSONField(name = "spmc")
            private String itemSimpleName;

            /**
             * 商品简称
             */
            @JSONField(name = "spjc")
            private String itemShortName;

            /**
             * 征收品目代码
             */
            @JSONField(name = "zspmdm")
            private String collectionItems;

            /**
             * 征收品目名称
             */
            @JSONField(name = "zspmmc")
            private String collectionName;
        }
    }

}
