package com.xforceplus.taxware.leqi.kernel.contract.model.seller;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author lv
 * @date 2023/1/18
 * @describe: 查询房源信息
 */
public class PostPropertyInfoMessage {

    @Data
    public static class Request {

        /**
         * 登记序号 20 是
         */
        @JSONField(name = "djxh")
        private String registerNo;

        /**
         * 省级税务机关代码 11 是
         */
        @JSONField(name = "sjswjgdm")
        private String provincialTaxAuthorityCode;

        /**
         * 房地产开发项目编号 20 是
         */
        @JSONField(name = "fdckfxmbh")
        private String landVatItemNo;

        /**
         * 不动产单位代码 28
         */
        @JSONField(name = "bdcdwdm")
        private String realEstateCode;

        /**
         * 网签合同编号 28
         */
        @JSONField(name = "wqhtbh")
        private String contractNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 房源信息
         */
        @JSONField(name = "fyxxList")
        private PropertyInfo propertyInfoList;

        @Data
        public static class PropertyInfo {

            /**
             * 房地产开发项目 编号 20 是
             */
            @JSONField(name = "fdckfxmbh")
            private String landVatItemNo;

            /**
             * 房地产开发项目 名称 300 是
             */
            @JSONField(name = "fdckfxmmc")
            private String landVatItemName;

            /**
             * 房地产开发项目 地址 300 是
             */
            @JSONField(name = "fdckfxmdz")
            private String landVatItemAddress;

            /**
             * 房屋幢号 100 否
             */
            @JSONField(name = "fwzh")
            private String buildingNo;

            /**
             * 单元号 20 是
             */
            @JSONField(name = "dyh")
            private String unitNo;

            /**
             * 楼层 300 否
             */
            @JSONField(name = "lc")
            private String storey;

            /**
             * 房号 15 否
             */
            @JSONField(name = "fh")
            private String roomNo;

            /**
             * 预测建筑面积 number
             * 16,4
             */
            @JSONField(name = "ycjzmj")
            private String predictedFloorageArea;

            /**
             * 预测套内面积
             * number
             * 16,4
             */
            @JSONField(name = "yctnmj")
            private String predictedFloorageAreaInside;

            /**
             * 实测建筑面积
             * number
             * 16,4
             * 否
             */
            @JSONField(name = "scjzmj")
            private String realFloorageArea;

            /**
             * 实测套内面积
             * number
             * 16,4
             * 否
             */
            @JSONField(name = "sctnmj")
            private String realFloorageAreaInside;

            /**
             * 不动产单位代码
             * varchar
             * 28
             * 否
             */
            @JSONField(name = "bdcdwdm")
            private String realEstateCode;

            /**
             * 网签合同编号
             * varchar
             * 28
             * 否
             */
            @JSONField(name = "wqhtbh")
            private String contractNo;

            /**
             * 合同金额
             * number
             * 18,2
             * 否
             */
            @JSONField(name = "htje")
            private String amount;

            /**
             * 购房人名称
             * varchar
             * 300
             * 否
             */
            @JSONField(name = "gfrmc")
            private String buyerName;

            /**
             * 购房人证件类型 代码
             * varchar
             * 300
             * 否
             */
            @JSONField(name = "gfrzjlxdm")
            private String buyerIdentityType;

            /**
             * 购房人证件号码
             * varchar
             * 300
             * 否
             */
            @JSONField(name = "gfrzjhm")
            private String buyerNo;

        }
    }
}
