package com.xforceplus.taxware.leqi.kernel.contract.model.seller.style;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.util.List;

/**
 * @Auther lv
 * @Date 2025/2/17
 * @Description 不动产租赁特殊要素信息
 */
@Data
public class RealEstateLease {

    /**
     * 序号
     * 需要和发票明细一一对应
     */
    @JSONField(name = "xh")
    private Integer rowNum;

    /**
     * 不动产坐落地址（省）
     */
    @JSONField(name = "bdczldzS")
    private String realEstateProvince;

    /**
     * 不动产坐落地址（市）
     */
    @JSONField(name = "bdczldzS1")
    private String realEstateCity;

    /**
     * 不动产坐落地址（详细地址）
     */
    @JSONField(name = "bdczldzXxdz")
    private String realEstateAddress;

    /**
     * 租赁期起止
     * date
     * 40
     * 是
     * “租赁期 起 ”+“ 空格”+“租赁期止”，其中租赁期起、止的格式为: yyyy-MM-dd 或 yyyy-MM-dd HH:mm
     */
    @JSONField(name = "zlqqz")
    private String leaseTerm;

    /**
     * 跨地(市)标志
     * varchar
     * 1
     * 是
     * Y是N否
     */
    @JSONField(name = "kdsbz")
    private String crossCitySign;

    /**
     * 产权证书/不动产权证号
     * varchar
     * 40
     * 否
     */
    @JSONField(name = "cqzsbh")
    private String realEstateNo;

    /**
     * 车牌号
     */
    @JSONField(name = "cph")
    private List<String> vehicleNo;
}
