package com.xforceplus.taxware.leqi.kernel.contract.model.seller.style;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * @Auther lv
 * @Date 2023/10/11
 * @Description 货物运输特殊要素信息
 */
@Data
public class TransportServices {

    /**
     * 运输明细序号
     * Number
     * 8
     * 是
     */
    @JSONField(name = "ysmxxh")
    private Integer rowNum;

    /**
     * 起运地
     * varchar
     * 80
     * 是
     */
    @JSONField(name = "qyd")
    private String placeOfShipment;

    /**
     *
     * 到达地
     * varchar
     * 80
     * 是
     */
    @JSONField(name = "ddd")
    private String destination;

    /**
     * 运输工具种类
     * varchar
     * 40
     * 是
     * 铁路运输
     * 公路运输
     * 水路运输
     * 航空运输
     * 管道运输
     */
    @JSONField(name = "ysgjzl")
    private String toolType;

    /**
     * 运输工具牌号
     * varchar
     * 40
     * 是
     */
    @JSONField(name = "ysgjph")
    private String toolBrand;

    /**
     * yshwmc
     * varchar
     * 80
     * 是
     */
    @JSONField(name = "yshwmc")
    private String nameOfGoods;
}
