/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.leqi.kernel.contract.model.util;

import com.xforceplus.taxware.leqi.kernel.contract.model.exception.Sm4DecryptException;
import com.xforceplus.taxware.leqi.kernel.contract.model.exception.Sm4EncryptException;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;

public class SM4Utils {
    public static final String ALGORITHM_NAME = "SM4";
    public static final String ALGORITHM_NAME_ECB_PADDING = "SM4/ECB/PKCS5Padding";

    public static String encrypt(@NotNull String secretKey, @NotNull String content) {
        try {
            Cipher cipher = SM4Utils.generateCipher(1, secretKey);
            byte[] encodeContent = Base64.encodeBase64((byte[])cipher.doFinal(content.getBytes(StandardCharsets.UTF_8)));
            return new String(encodeContent, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new Sm4EncryptException(e);
        }
    }

    public static String decrypt(@NotNull String secretKey, @NotNull String content) {
        try {
            Cipher cipher = SM4Utils.generateCipher(2, secretKey);
            return new String(cipher.doFinal(Base64.decodeBase64((String)content)), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new Sm4DecryptException(e);
        }
    }

    private static Cipher generateCipher(int mode, String secretKey) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM_NAME_ECB_PADDING, "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(Hex.decodeHex((char[])secretKey.toCharArray()), ALGORITHM_NAME);
        cipher.init(mode, sm4Key);
        return cipher;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

