package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.deduction;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @Auther lv
 * @Date 2023/7/7
 * @Description 获取当前税款所属期海关缴款书抵扣勾选处理结果
 */
public class PostCurrentTaxPeriodCustomsPaymentDeduction {
    @Data
    public static class Request {
        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：30
         * 非必需
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        /**
         * 查询页码
         * int
         * 不传默认为 1，可根据返回的总页数调整所需要查询的页码数据
         */
        @JSONField(name = "cxym")
        private String pageNumber;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 总页数
         * int
         * 必需
         */
        @JSONField(name = "zys")
        private String totalPageCount;

        /**
         * 当前页码
         * int
         * 必需
         * 每页 200 条
         */
        @JSONField(name = "dqym")
        private String pageSize;

        @JSONField(name = "hgjksgxcljgmx")
        private List<Detail> detailList;

        @Data
        public static class Detail {
            /**
             * 缴款书号码
             * 长度：22
             * 必填
             */
            @JSONField(name = "jkshm")
            private String customsPaymentNo;

            /**
             * 出口转内销证明编号
             * 长度：30
             * 非必填
             * 如为出口转内销需上传转内销证明编号
             */
            @JSONField(name = "ckznxzmbh")
            private String exportToDomesticSalesCertificateNo;

            /**
             * 填发日期
             * 长度：8
             * 必填
             * YYYYMMDD
             */
            @JSONField(name = "tfrq")
            private String dateIssued;

            /**
             * 税款所属期
             * 格式YYYYMM，退税成功时该字段不为空
             * 长度：6
             * 非必填
             */
            @JSONField(name = "skssq")
            private String taxPeriod;

            /**
             * 勾选时间
             * 长度：8
             * 非必填
             * 撤销勾选时，此字段为空
             * YYYYMMDD
             */
            @JSONField(name = "gxsj")
            private String deductionDate;

            /**
             * 当前勾选用途
             * 长度：2
             * 非必填
             * 1：已申请抵扣
             * 4：已申请不抵扣（历史数据）
             * 6：已申请不抵扣
             */
            @JSONField(name = "hxyt")
            private String deductionPurpose;

            /**
             * 是否重号锁定
             * 长度：1
             * 必填
             * Y：锁定
             * N：未锁定（01：对方重号 , 对方申请核对）需要对照转化为上述锁定和未锁定代码
             */
            @JSONField(name = "sfchsd")
            private String duplicateStatus;
        }
    }
}
