package com.xforceplus.taxware.leqi.kernel.contract.model.collection;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author lvwenjing
 * @date 2023/4/21
 * @describe: 查询增量下载增值税代扣代缴完税凭证信息
 */
public class PostVatTaxPaymentVoucherIncrementMessage {

    @Data
    public static class Request {

        /**
         * 归集日期
         * 长度：8
         * YYYYMMDD(当前日期7天内某一天的日期)
         */
        @JSONField(name = "gjrq")
        private String dateCollect;

        /**
         * 扣缴义务人识别号,纳税人识别号/统一社会信用代码
         * 长度：30
         */
        @JSONField(name = "kjywrsbh")
        private String taxNo;

        /**
         * 数据包号，当数据量过大时会进行分包处理，初始包号1
         * 长度：5
         */
        @JSONField(name = "packageno")
        private String packageNo;

    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 当前流水号下 的总包数
         * 长度：5
         */
        @JSONField(name = "packagecount")
        private String packageCount;

        /**
         * 扣缴义务人识别号,纳税人识别号/统一社会信用代码
         * 长度：30
         */
        @JSONField(name = "kjywrsbh")
        private String taxNo;

        /**
         * 归集日期
         * 长度：8
         * YYYYMMDD(当前日期7天内某一天的日期)
         */
        @JSONField(name = "gjrq")
        private String dateCollect;

        /**
         * 数据类型
         * 长度：1
         * 1:进项票
         * 2:销项票
         */
        @JSONField(name = "sjlx")
        private String dataType;

        /**
         * 数据类型
         * 压缩包文件流 (gzip+base64)，
         * 原始数据为json报文Json
         */
        @JSONField(name = "sjl")
        private String returnData;
    }
}
