package com.xforceplus.taxware.leqi.kernel.contract.model.publish;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author lvwenjing
 * @date 2025/10/13
 * @describe: 版本发布情况查询
 */
public class PostVersionPublishInfoMessage {

    @Data
    public static class Request {

        /**
         * 能力编码 否
         */
        @JSONField(name = "nlbm")
        private String capabilityCode;

        /**
         * 沙箱环境发布时间起 否
         * YYYY-MM-DD
         * HH:mm:ss
         */
        @JSONField(name = "sxhjfbsjq")
        private String startTimeSandboxPublish;

        /**
         * 沙箱环境发布时间止 否
         * YYYY-MM-DD
         * HH:mm:ss
         */
        @JSONField(name = "sxhjfbsjz")
        private String endTimeSandboxPublish;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 版本发布情况列表
         */
        @JSONField(name = "bbfbqkList")
        private List<VersionInfo> versionInfoList;

        @Data
        public static class VersionInfo {

            /**
             * 版本号 varchar 75 是 发布生产环境时申请的版本号
             * 是
             */
            @JSONField(name = "bbh")
            private String versionNo;

            /**
             * 沙箱环境发布时间 varchar 19 是 YYYY-MM-DD HH:mm:ss
             */
            @JSONField(name = "sxhjfbsj")
            private String sandboxPublishTime;

            /**
             * 生产环境上线时间 varchar 19 是 YYYY-MM-DD HH:mm:ss
             */
            @JSONField(name = "schjsxsj")
            private String productPublishTime;

            /**
             * 服务变更列表
             */
            @JSONField(name = "fwbgList")
            private List<CapabilityInfo> capabilityInfoList;
        }

        @Data
        public static class CapabilityInfo {
            /**
             * nlbm 能力编nlbm码 varchar 6 是
             */
            @JSONField(name = "nlbm")
            private String capabilityCode;

            /**
             * nlmc 能力名称 varchar 450 是
             */
            @JSONField(name = "nlmc")
            private String capabilityName;

            /**
             * nlwdbbh 能力文档版本号 varchar 100 是
             */
            @JSONField(name = "nlwdbbh")
            private String capabilityDocVersionNo;

            /**
             * fwbm 服务编码 varchar 100 是
             */
            @JSONField(name = "fwbm")
            private String serviceCode;

            /**
             * xgsm 修改说明 varchar 3000 是
             */
            @JSONField(name = "xgsm")
            private String remark;

            /**
             * sfzd 是否阻断 varchar 1 是 Y：阻断（自有系统需改造）
             * N：不阻断（兼容上一版本）
             * 是
             */
            @JSONField(name = "sfzd")
            private String isBlock;
        }
    }
}
