package com.xforceplus.taxware.leqi.kernel.contract.model.seller;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @date 2025/8/25
 * @describe: 查询购方是否为试点地区企业，单个购方信息建议查询一次
 */
public class PostJewelryPilotMessage {

    @Data
    public static class Request {
        /**
         * 纳税人识别号/统一社会信用代码
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 纳税人识别号/统一社会信用代码
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;

        /**
         * 是否为试点地区企业
         * Y：是
         * N：否
         */
        @JSONField(name = "sfwsddqqy")
        private String pilotParticipantFlag;
    }
}

