package com.xforceplus.taxware.leqi.kernel.contract.model.supervision.compliance;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author lvwenjing
 * @date 2024/12/26
 * @describe: 上传指标扫描结果
 */
public class PostIndexUploadMessage {

    @Data
    public static class Request {

        /**
         * 32
         * 主键，企业端生成，按月数据如果存在更新，重新上传覆盖
         */
        @JSONField(name = "id")
        private String id;
        /**
         * 业务类型 是
         * LQJG001 指标扫描汇总结果上报 直连单位分使用单位、按扫描指标为维度按月（每月15日前）汇总上传。
         * LQJG002 指标扫描疑点上报 企业端业务系统触发“管控措施”为“疑点上报”的实质合规指标时，如果属于命中即需上报税务机关的指标规则时，应及时按要求通过本接口上报疑点数据。
         */
        @JSONField(name = "ywlx")
        private String businessType;

        /**
         * 上报时间
         */
        @JSONField(name = "sbsj")
        private String uploadTime;

        /**
         * 主键，记录本次上传的批次流水号
         */
        @JSONField(name = "pclsh")
        private String taskId;

        /**
         * 数据流
         */
        @JSONField(name = "sjl")
        private String data;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

    }
}
