package com.xforceplus.taxware.leqi.kernel.contract.model.unit;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author lvwenjing
 * @date 2023/7/22
 * @describe: 使用单位申请接口
 */
public class PostUseUnitApplyMessage {

    @Data
    public static class Request {

        /**
         * 使用单位信息
         * 是
         */
        @JSONField(name = "sydwxx")
        private List<NsUnit> nsUnitList;

        @Data
        public static class NsUnit {

            /**
             * 使用单位纳税人 识别号/统一社会 信用代码 20
             * 是
             */
            @JSONField(name = "sydwshxydm")
            private String taxNo;

            /**
             * 使用单位纳税人 名称 300
             * 是
             */
            @JSONField(name = "sydwnsrmc")
            private String taxpayerName;

            /**
             * 省市级税务机关 代码
             * 20
             * 是
             */
            @JSONField(name = "ssjswjgDm")
            private String provincialTaxAuthorityCode;

            /**
             * 省市级税务机关 名称
             * 300
             * 是
             */
            @JSONField(name = "ssjswjgmc")
            private String provincialTaxAuthorityName;

            /**
             * 与直连单位关系
             * 2
             * 是
             * 04-不具有控 制关系
             */
            @JSONField(name = "dwgxDm")
            private String relationshipType;

            /**
             * 与直连单位关系 证明文件
             * 文件内容 Base64
             */
            @JSONField(name = "dwgxzmcl")
            private String relationshipFile;

            /**
             * 能力授权邀请列 表
             * 否
             */
            @JSONField(name = "nlsqyqList")
            private List<Capability> capabilityList;

            @Data
            private static class Capability {

                /**
                 * 能力编码
                 * 是
                 */
                @JSONField(name = "nlbm")
                private String capabilityCode;

                /**
                 * 能力名称
                 * 否
                 */
                @JSONField(name = "nlmc")
                private String capabilityName;

                /**
                 * 能力授期有效期 起 时间格式: YYYY-MM-DD
                 * 是
                 */
                @JSONField(name = "yxqq")
                private String startDate;

                /**
                 * 能力授期有效期 止 时间格式: YYYY-MM-DD
                 * 是
                 */
                @JSONField(name = "yxqz")
                private String endDate;

            }
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        // 待补充
    }
}
