package com.xforceplus.taxware.leqi.kernel.contract.model.verification;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @Auther lv
 * @Date 2023/9/7
 * @Description 发票查验
 */
public class PostInvoiceVerify {
    @Data
    public static class Request {

        /**
         * 纳税人识别号
         * 长度：20
         * 必填
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;

        /**
         * 发票类型
         * 长度：2
         * 必填
         * 01:增值税专 用发票 02:货物运输 业增值税专用 发票 03:机动车销 售统一发票 04:增值税普 通发票 08:增值税电 子专用发票 10:增值税电 子普通发票 11:卷式发票 14:通行费发 票 15:二手车销 售统一发票 81:电子发票 (增值税专用 发票) 82:电子发票 (普通发票)
         * 85:纸质发票 (增值税专用 发票) 86:纸质发票 (普通发票) 51:电子发票 (铁路电子客 票)
         * 61:电子发票 (航空运输客 票电子行程 单)
         */
        @JSONField(name = "fplx")
        private String invoiceType;

        /**
         * 发票代码
         * 长度：12
         * 非必填
         * 发票类型为: 01、02、03、 04、08、10、 11、14、15、 85、86 传纸质 发票代码
         */
        @JSONField(name = "fpdm")
        private String invoiceCode;

        /**
         * 发票号码
         * 长度：20
         * 必填
         * 发票类型为: 01、02、03、 04、08、10、 11、14、15、 85、86 传纸质 发票号码 发票类型为: 81、82、51、 61传20位数字 化电子发票号 码
         */
        @JSONField(name = "fphm")
        private String invoiceNo;

        /**
         * 开票日期
         * 长度：8
         * 必填
         * YYYYMMDD
         */
        @JSONField(name = "kprq")
        private String dateIssued;

        /**
         * 校验码
         * 长度：32
         * 非必填
         */
        @JSONField(name = "jym")
        private String checkCode;

        /**
         * 开票金额
         * 长度：12
         * 非必填
         * 税控票为不含税金额，数字化电子发票为价税合计
         */
        @JSONField(name = "kpje")
        private Number amount;

    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 查验结果信息
         * 长度：20000
         * 必填
         * 压缩包文件流 (zip+base64 )，原始数据 为 json 报文 Json 报文格式 详见:附件一 (发票票面信 息数据说明)
         */
        @JSONField(name = "cyjgxx")
        private String returnData;

    }
}
