package com.xforceplus.taxware.contract.allelectric.message;

import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulParameterDTO;
import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulResponseDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 红字信息表列表查询接口(异步)
 *
 * https://api-mock.xforceplus.com/project/136/interface/api/38995
 */
public class GetRedInfoTableMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Parameter extends BaseRestfulParameterDTO {

        /**
         * 请求流水号 [50]
         **/
        private String serialNo;

        /**
         * 3.0MI账号,针对开票软件发起全电红字列表查询时传入(仅支持购方操作) [50]
         **/
        private String mi;

        /**
         * 4.0终端唯一码,针对开票软件发起全电红字列表查询时传入(仅支持购方操作) [10]
         **/
        private String terminalUn;

        /**
         * 4.0设备唯一码,针对开票软件发起全电红字列表查询时传入(仅支持购方操作) [10]
         **/
        private String deviceUn;

        /**
         * 查询方税号 [20]
         **/
        private String queryTaxCode;

        /**
         * 查询方身份(01 - 销方, 02 - 购方) [2]
         **/
        private String queryIdentity;

        /**
         * 状态[2]
         * 01-无需确认,
         * 02-销方录入待购方确认,
         * 03-购方录入待销方确认,
         * 04-购销双方已确认,
         * 05-作废（销方录入购方否认）,
         * 06-作废（购方录入销方否认）,
         * 07-作废（超72小时未确认）
         **/
        private String status;

        /**
         * 是否查询红字详情(默认: false，该字段传值时需谨慎, 查询局端代价非常重) [10]
         **/
        private String queryDetails = "false";
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseRestfulResponseDTO {

        /**
         * 结果
         **/
        private Result result;

        @Data
        public static class Result {

            /**
             * 请求流水号
             **/
            private String serialNo;
        }
    }
}
