package com.xforceplus.taxware.contract.allelectric.message;

import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulResponseDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 红字信息表操作接口(异步)
 *
 * https://api-mock.xforceplus.com/project/136/interface/api/38990
 */
public class PatchRedInfoTableFlowStatusMessage {

    @Data
    public static class Request {

        /**
         * 请求流水号 [50]
         **/
        private String serialNo;

        /**
         * 红字信息UUid [32]
         **/
        private String redInformationUuid;

        /**
         * 设备账号信息(发起客户端开票软件红字操作时, 必填; 全电发票时无需赋值)，也作为区分客户端和全电的依据
         **/
        private AccountInfo deviceAccount;

        @Data
        public static class AccountInfo {

            /**
             * 3.0MI账号,针对开票软件发起全电红字申请时传入(仅支持购方申请) [50]
             **/
            private String mi;

            /**
             * 4.0终端唯一码,针对开票软件发起全电红字申请时传入(仅支持购方申请) [10]
             **/
            private String terminalUn;

            /**
             * 4.0设备唯一码,针对开票软件发起全电红字申请时传入(仅支持购方申请) [10]
             **/
            private String deviceUn;
        }

        /**
         * 确认方税号 [20]
         **/
        private String confirmTaxCode;

        /**
         * 确认方身份(01 - 销方, 02 - 购方) [2]
         **/
        private String confirmIdentity;

        /**
         * 确认状态(01-同意, 02-不同意, 03-撤销) [2]
         **/
        private String confirmStatus;

        /**
         * 购方税号(发起客户端红字操作时传入, 全电时不传) [20]
         **/
        private String purchaserTaxCode;

        /**
         * 销方税号(发起客户端红字操作时传入, 全电时不传) [20]
         **/
        private String sellerTaxCode;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseRestfulResponseDTO {

        /**
         * 结果
         **/
        private Result result;

        @Data
        public static class Result {

            /**
             * 请求流水号
             **/
            private String serialNo;
        }
    }
}
