package com.xforceplus.taxware.contract.allelectric.message;

import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulResponseDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 红字信息表申请接口(异步)
 *
 * https://api-mock.xforceplus.com/project/136/interface/api/38985
 */
public class PostRedInfoTableMessage {

    @Data
    public static class Request {

        /**
         * 流水号 [50]
         **/
        private String serialNo;

        /**
         * 单据唯一号 [50]
         **/
        private String pid;

        /**
         * 设备账号信息(发起客户端开票软件红字申请时, 必填; 全电发票时无需赋值)，也作为区分客户端和全电的依据
         **/
        private AccountInfo deviceAccount;

        @Data
        public static class AccountInfo {

            /**
             * 3.0MI账号,针对开票软件发起全电红字申请时传入(仅支持购方申请) [50]
             **/
            private String mi;

            /**
             * 4.0终端唯一码,针对开票软件发起全电红字申请时传入(仅支持购方申请) [10]
             **/
            private String terminalUn;

            /**
             * 4.0设备唯一码,针对开票软件发起全电红字申请时传入(仅支持购方申请) [10]
             **/
            private String deviceUn;
        }

        /**
         * 申请方税号 [20]
         **/
        private String applyTaxCode;

        /**
         * 申请方身份(01 - 销方, 02 - 购方) [2]
         **/
        private String applyIdentity;

        /**
         * 购方信息
         **/
        private PurchaserInfo purchaser;

        @Data
        public static class PurchaserInfo {

            /**
             * 购方税号 [20]
             **/
            private String purchaserTaxCode;

            /**
             * 购方名称 [180]
             **/
            private String purchaserName;
        }

        /**
         * 销方信息
         **/
        private SellerInfo seller;

        @Data
        public static class SellerInfo {

            /**
             * 销方税号 [20]
             **/
            private String sellerTaxCode;

            /**
             * 销方名称 [180]
             **/
            private String sellerName;
        }

        /**
         * 原蓝票信息
         **/
        private InvoiceInfo originalInvoice;

        @Data
        public static class InvoiceInfo {

            /**
             * 原蓝票发票号码 [20]
             **/
            private String invoiceNo;

            /**
             * 原蓝票发票类型：qc - 电普, qs - 电专 [2]
             **/
            private String invoiceType;

            /**
             * 原蓝票增值税用途(1-勾选抵扣, 2-出口退税, 3-代办出口退税, 4-不抵扣) [2]
             **/
            private String invoiceVatUse;

            /**
             * 原蓝票发票金额 [18,2]
             **/
            private BigDecimal amountWithoutTax;

            /**
             * 原蓝票税额 [18,2]
             **/
            private BigDecimal taxAmount;

            /**
             * 发票入账状态(0-未入账, 1-已入账) [1]
             **/
            private String recordedStatus;
        }

        /**
         * 红冲原因(01 - 销货全部退回, 02 - 销货部分退回, 03 - 开票有误, 04 - 应税服务中止, 05 - 销售折让) [2]
         **/
        private String redReason;

        /**
         * 红冲金额 [18,2]
         **/
        private BigDecimal redAmount;

        /**
         * 红冲税额 [18,2]
         **/
        private BigDecimal redTaxAmount;

        /**
         * 明细列表
         **/
        private List<Details> details;

        @Data
        public static class Details {

            /**
             * 明细金额信息
             **/
            private AmountInfo detailAmount;

            @Data
            public static class AmountInfo {

                /**
                 * 不含税金额 [18,2]
                 **/
                private BigDecimal amountWithoutTax;

                /**
                 * 数量 [27,15]
                 **/
                private BigDecimal quantity;

                /**
                 * 税额 [18,2]
                 **/
                private BigDecimal taxAmount;

                /**
                 * 单价 [27,15]
                 **/
                private BigDecimal unitPrice;
            }

            /**
             * 商品信息
             **/
            private ProductionInfo production;

            @Data
            public static class ProductionInfo {

                /**
                 * 商品名称 [92]
                 **/
                private String productionName;

                /**
                 * 规格型号 [40]
                 **/
                private String specification;

                /**
                 * 单位 [22]
                 **/
                private String unitName;
            }

            /**
             * 税收信息
             **/
            private TaxInfo tax;

            @Data
            public static class TaxInfo {

                /**
                 * 税率 [18,2]
                 **/
                private BigDecimal taxRate;

                /**
                 * 税收分类编码 [20]
                 **/
                private String taxClassCode;

                /**
                 * 优惠政策标识(01-简易征收, 02-即征即退, 03-稀土产品, 04-免税, 05-不征税, 06-先征后退) [2]
                 **/
                private String taxPolicyTag;
            }
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseRestfulResponseDTO {

        /**
         * 结果
         **/
        private Result result;

        @Data
        public static class Result {

            /**
             * 请求流水号
             **/
            private String serialNo;
        }
    }
}
