package com.xforceplus.taxware.contract.allelectric.message;

import com.google.common.collect.Lists;
import lombok.Data;

import java.util.List;

/**
 * 全电发票开票人列表查询
 * <p>
 * 契约地址：https://api-mock.xforceplus.com/project/141/interface/api/41214
 */
public class GetIssuerListMessage {

    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message = "成功";

        /**
         * 追踪码
         */
        private String traceId;

        /**
         * 结果
         **/
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 税号
             **/
            private String taxNo;

            /**
             * 登录方式 client：客户端登录 server：服务端登录
             **/
            private String loginType;

            /**
             * 开票人列表
             */
            private List<Issuer> issuers = Lists.newArrayList();

        }

        @Data
        public static class Issuer {

            /**
             * 开票人
             **/
            private String issuer;

            /**
             * 在线标志,true:在线 false:不在线
             **/
            private boolean onlineFlag;

        }
    }
}
