package com.xforceplus.taxware.contract.allelectric.message;

import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulParameterDTO;
import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulResponseDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 红字信息表详情查询接口(异步)
 *
 * https://api-mock.xforceplus.com/project/136/interface/api/39005
 */
public class GetRedInfoTableDetailMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Parameter extends BaseRestfulParameterDTO {

        /**
         * 请求流水号 [50]
         **/
        private String serialNo;

        /**
         * 3.0MI账号,针对开票软件发起全电红字列表查询时传入(仅支持购方操作) [50]
         **/
        private String mi;

        /**
         * 4.0终端唯一码,针对开票软件发起全电红字列表查询时传入(仅支持购方操作) [10]
         **/
        private String terminalUn;

        /**
         * 4.0设备唯一码,针对开票软件发起全电红字列表查询时传入(仅支持购方操作) [10]
         **/
        private String deviceUn;

        /**
         * 查询方税号 [20]
         **/
        private String queryTaxCode;

        /**
         * 红字信息UUid [32]
         **/
        private String redInformationUuid;

        /**
         * 销方税号 [20]
         **/
        private String sellerTaxCode;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseRestfulResponseDTO {

        /**
         * 结果
         **/
        private GetRedInfoTableMessage.Response.Result result;

        @Data
        public static class Result {

            /**
             * 请求流水号
             **/
            private String queryTaxCode;
        }
    }
}
