package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 红字信息表列表查询结果
 *
 * https://xforceplus.yuque.com/dew9bm/yagacb/ddv1qd
 */
@Data
public class GetRedInfoTableResultMessage {

    /**
     * 错误码：成功：TXWR000000，失败：其他编码
     **/
    private String code;

    /**
     * 描述
     **/
    private String message;

    /**
     * 结果
     **/
    private Result result;

    @Data
    public static class Result {

        /**
         * 流水号
         **/
        private String serialNo;

        /**
         * 红字信息列表
         **/
        private List<RedInformation> redInformationList;

        @Data
        public static class RedInformation {

            /**
             * 红字信息UUid
             **/
            private String redInformationUuid;

            /**
             * 申请方身份
             **/
            private String applyIdentity;

            /**
             * 购方信息
             **/
            private PurchaserInfo purchaser;

            @Data
            public static class PurchaserInfo {

                /**
                 * 购方税号
                 **/
                private String purchaserTaxCode;

                /**
                 * 购方名称
                 **/
                private String purchaserName;
            }

            /**
             * 销方信息
             **/
            private SellerInfo seller;

            @Data
            public static class SellerInfo {

                /**
                 * 销方税号
                 **/
                private String sellerTaxCode;

                /**
                 * 销方名称
                 **/
                private String sellerName;
            }

            /**
             * 原蓝票信息
             **/
            private InvoiceInfo originalInvoice;

            @Data
            public static class InvoiceInfo {

                /**
                 * 发票号码
                 **/
                private String invoiceNo;

                /**
                 * 发票类型
                 **/
                private String invoiceType;
            }

            /**
             * 红冲原因
             **/
            private String redReason;

            /**
             * 红冲金额
             **/
            private BigDecimal redAmount;

            /**
             * 红冲税额
             **/
            private BigDecimal redTaxAmount;

            /**
             * 红字确认信息状态
             **/
            private String status;

            /**
             * 已开具红字发票标记
             **/
            private String redInvoiceTag;

            /**
             * 红字发票号码
             **/
            private String redInvoiceNo;
        }
    }
}
