package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 全电发票开具接口(异步)
 * <p>
 * https://api-mock.xforceplus.com/project/136/interface/api/38980
 */
public class PostInvoiceMessage {

    @Data
    public static class Request {

        /**
         * 流水号 [32]
         **/
        private String taskId;

        /**
         * 开票模式(issue-仅开具)
         */
        private String mode = "issue";

        /**
         * 预制发票id
         **/
        private String pid;

        /**
         * 发票类型
         * qc:全电电普
         * qs:全电电专
         **/
        private String invoiceType;

        /**
         * 特殊票种标签(本期不包含)
         * 00：非收购
         * 01：农产品收购
         * 02：光伏收购
         * 03：二手车收购
         **/
        private String specialInvoiceTag = "00";

        /**
         * 追踪信息
         **/
        private TraceInfo trace;

        @Data
        public static class TraceInfo {

            /**
             * 单据编号
             **/
            private String receiptNo;
        }

        /**
         * 销方信息
         **/
        private SellerInfo seller;

        @Data
        public static class SellerInfo {

            /**
             * 销方名称 [180]
             **/
            private String sellerName;

            /**
             * 销方税号 [20]
             **/
            private String sellerTaxNo;

            /**
             * 销方地址 [180]
             **/
            private String sellerAddress;

            /**
             * 销方电话 [20]
             **/
            private String sellerTel;

            /**
             * 销方开户行 [80]
             **/
            private String sellerBankName;

            /**
             * 销方开户行账号 [40]
             **/
            private String sellerBankAccount;
        }

        /**
         * 购方信息
         **/
        private BuyerInfo buyer;

        @Data
        public static class BuyerInfo {

            /**
             * 购方名称 [180]
             **/
            private String buyerName;

            /**
             * 购方税号 [20]
             **/
            private String buyerTaxNo;

            /**
             * 购方地址 [180]
             **/
            private String buyerAddress;

            /**
             * 购方电话 [20]
             **/
            private String buyerTel;

            /**
             * 购方开户行 [80]
             **/
            private String buyerBankName;

            /**
             * 购方开户行账号 [40]
             **/
            private String buyerBankAccount;
        }

        /**
         * 操作人信息
         **/
        private OperatorInfo operator;

        @Data
        public static class OperatorInfo {

            /**
             * 开票人
             **/
            private String issuer;
        }

        /**
         * 发票金额信息
         **/
        private InvoiceAmountInfo invoiceAmount;

        @Data
        public static class InvoiceAmountInfo {

            /**
             * 合计金额（18位，2位小数）
             **/
            private BigDecimal amountWithoutTax;

            /**
             * 价税合计（18位，2位小数）
             **/
            private BigDecimal amountWithTax;

            /**
             * 合计税额（18位，2位小数）
             **/
            private BigDecimal taxAmount;
        }

        /**
         * 红字信息
         **/
        private RedLetterInfo redLetter;

        @Data
        public static class RedLetterInfo {

            /**
             * 原发票号码(本期不包含) [20]
             **/
            private String originalInvoiceNo;

            /**
             * 红字确认单编号(本期不包含) [32]
             **/
            private String redLetterNumber;
        }

        /**
         * 备注 [200]
         **/
        private String remark;

        /**
         * 价格方式(1-含税,0-不含税，默认: 不含税)
         * 本期仅含不含税开具
         */
        private String pricingMethod = "0";

        /**
         * 明细列表
         **/
        private List<Details> details;

        @Data
        public static class Details {

            /**
             * pid
             */
            private String pid;

            /**
             * 明细金额信息
             **/
            private DetailAmountInfo detailAmount;

            @Data
            public static class DetailAmountInfo {

                /**
                 * 数量（16位，小数位不超过13位）（单位非空时非空）
                 **/
                private BigDecimal quantity;

                /**
                 * 不含税单价（16位，小数位不超过13位）（单位非空时非空）
                 **/
                private BigDecimal unitPrice;

                /**
                 * 不含税金额（18位，2位小数）
                 **/
                private BigDecimal amountWithoutTax;

                /**
                 * 税额（18位，2位小数）
                 **/
                private BigDecimal taxAmount;

                /**
                 * 含税金额（18位，2位小数）
                 **/
                private BigDecimal amountWithTax;
            }

            /**
             * 折扣金额信息
             */
            private DiscountAmountInfo discountAmount;

            @Data
            public static class DiscountAmountInfo {

                /**
                 * 小数点保留最多2位 不含税折扣额
                 */
                private BigDecimal discountWithoutTax;

                /**
                 * 小数点保留最多2位 折扣税额
                 */
                private BigDecimal discountTax;

                /**
                 * 小数点保留最多2位 含税折扣额
                 */
                private BigDecimal discountWithTax;
            }

            /**
             * 商品信息
             **/
            private ItemInfo item;

            @Data
            public static class ItemInfo {

                /**
                 * 商品名称（*简称*商品名称） [100]
                 **/
                private String itemName;

                /**
                 * 规格型号 [40]
                 **/
                private String specifications;

                /**
                 * 单位 [20]
                 **/
                private String unit;
            }

            /**
             * 税务信息
             **/
            private TaxInfo tax;

            @Data
            public static class TaxInfo {

                /**
                 * 税率
                 * （3%税率时传入0.03）
                 **/
                private BigDecimal taxRate;

                /**
                 * 税编 [19]
                 **/
                private String goodsTaxNo;

                /**
                 * 优惠政策标识 [2]
                 * 01 简易征收
                 * 02 即征即退
                 * 03 稀土产品
                 * 04 免税
                 * 05 不征税
                 * 06 先征后退
                 * （本期不包含）
                 **/
                private String taxPreTag;
            }
        }
    }

    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message;

        /**
         * 结果
         **/
        private Result result;

        @Data
        public static class Result {

            /**
             * 流水号 [32]
             **/
            private String taskId;
        }
    }
}
