package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

/**
 * 全电国税地址查询
 * <p>
 * https://api-mock.xforceplus.com/project/141/interface/api/41240
 */
public class GetChinaTaxUrlMessage {
    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message = "成功";

        /**
         * 追踪码
         */
        private String traceId;

        /**
         * 结果
         **/
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 税号
             **/
            private String taxNo;

            /**
             * 电子税务局地址
             **/
            private String eTaxUrl;
        }
    }
}
