package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * 计费服务查询
 *
 * https://api-mock.xforceplus.com/project/141/interface/api/41448
 */
public class GetSupportServiceMessage {

    @Data
    public static class Request {

        /**
         * 租户id
         */
        private String tenantId;

        /**
         * 税号
         */
        private String taxNo;

        /**
         * 服务名称(支持查询多个，以英文逗号分隔)
         */
        private String serviceNames;

        /**
         * 服务状态（enable：启用 disabled：停用，不传查询所有状态）
         */
        private String serviceStatus;

        /**
         * 开票（make）
         * 认证（authentication）
         * 验真（verification）
         * 抽取（assistant）
         * 低频同步（bravetroops）
         * 红字信息表申请（rnfnApply）
         * 红字信息表同步（rnfnDownload）
         * 发票归集（collection）
         */
        public enum ServiceNameEnum {
            MAKE("make"),
            AUTHENTICATION("authentication"),
            VERIFICATION("verification"),
            ASSISTANT("assistant"),
            BRAVETROOPS("bravetroops"),
            RNFN_APPLY("rnfnApply"),
            RNFN_DOWNLOAD("rnfnDownload"),
            COLLECTION("collection")
            ;

            private final String name;

            ServiceNameEnum(String name) {
                this.name = name;
            }

            public String getName() {
                return name;
            }
        }
    }

    @Data
    public static class Response {

        /**
         * 错误码 1：成功，其他为失败
         */
        private String code;
        private String message;
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 租户列表
             */
            private List<TenantDto> tenantList = new ArrayList<>();

            @Data
            public static class TenantDto {

                /**
                 * 租户ID
                 */
                private String tenantId;

                /**
                 * 服务列表
                 */
                private List<SupportServiceDto> serviceList;

                @Data
                public static class SupportServiceDto {

                    /**
                     * 服务名称
                     */
                    private String serviceName;

                    /**
                     * 服务开通时间(格式:yyyy-MM-dd HH:mm:ss.SSS)
                     */
                    private String enableTime;

                    /**
                     * 服务关闭时间（格式:yyyy-MM-dd HH:mm:ss.SSS）
                     */
                    private String disabledTime;

                    /**
                     * 创建人
                     */
                    private String createdBy;
                }
            }
        }
    }
}
