package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

/**
 * 红字信息表申请结果回调消息
 * <p>
 * https://xforceplus.yuque.com/dew9bm/yagacb/hn55gs
 */
@Data
public class PostRedInfoTableResultMessage {

    @Data
    public static class Properties {

        /**
         * 业务编号
         */
        private String businessNo;

        /**
         * 调用方系统
         */
        private String fromSystem;

        /**
         * 租户id
         */
        private String tenantId;
    }

    /**
     * 错误码：成功：1，失败：其他编码
     **/
    private String code = "1";

    /**
     * 描述
     **/
    private String message;

    /**
     * 结果
     **/
    private Result result = new Result();

    @Data
    public static class Result {

        /**
         * 请求流水号
         **/
        private String taskId;

        /**
         * 红字信息表编号
         **/
        private String redLetterNumber;

        /**
         * 红字信息表状态
         * 01-无需确认
         * 02-销方录入待购方确认
         * 03-购方录入待销方确认
         */
        private String status;

        /**
         * 红字信息表申请日期时间
         * yyyyMMddHHmmss
         */
        private String dateRedApplied;
    }
}
