package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class RnfnDownloadResultMessage {

    @Data
    public static class Properties {

        /**
         * 业务编号
         */
        private String businessNo;

        /**
         * 租户id
         */
        private String tenantId;
    }

    /**
     * 申请身份
     */
    private String applyIdentity;

    /**
     * 原蓝票号码
     */
    private String originalInvoiceNo;

    /**
     * 红字通知单编号
     */
    private String redInformationNo;

    /**
     * 发票金额
     */
    private BigDecimal invoiceAmount;

    /**
     * 发票税额 (18位，2位小数)
     */
    private BigDecimal taxAmount;

    /**
     * 冲红原因
     */
    private String redReason;

    /**
     * 状态
     */
    private String status;

    /**
     * 开具状态
     */
    private String confirmStatus;

    /**
     * 开票日期: yyyy-MM-dd
     */
    private String invoiceDate;

    /**
     * 增值税用途状态
     */
    private String vatPurpose;

    /**
     * 消费税用途状态
     */
    private String excisePurpose;

    /**
     * 入账状态
     */
    private String inAccountStatus;

    /**
     * 销方信息
     */
    private SellerDto seller;

    /**
     * 购方信息
     */
    private BuyerDto buyer;

    /**
     * 明细
     */
    private List<RnfnDetailDto> detailList;

    @Data
    public static class SellerDto {

        /**
         * 销方名称
         */
        private String sellerName;

        /**
         * 销方税号
         */
        private String sellerTaxNo;
    }

    @Data
    public static class BuyerDto {

        /**
         * 购方名称
         */
        private String buyerName;

        /**
         * 购方税号
         */
        private String buyerTaxNo;
    }

    @Data
    public static class RnfnDetailDto {

        /**
         * 明细金额
         */
        private DetailAmountDto detailAmount;

        /**
         * 商品信息
         */
        private ItemDto item;

        /**
         * 税收信息
         */
        private TaxDto tax;

        @Data
        public static class DetailAmountDto {

            /**
             * 不含税金额
             */
            private BigDecimal amountWithoutTax;

            /**
             * 数量
             */
            private BigDecimal quantity;

            /**
             * 单价
             */
            private BigDecimal unitPrice;

            /**
             * 税额
             */
            private BigDecimal taxAmount;
        }

        @Data
        public static class ItemDto {

            /**
             * 商品名称
             */
            private String itemName;

            /**
             * 规格型号
             */
            private String specifications;

            /**
             * 单位
             */
            private String unit;
        }

        @Data
        public static class TaxDto {

            /**
             * 税率
             */
            private BigDecimal taxRate;
        }
    }
}
