package com.xforceplus.taxware.contract.allelectric.message.enumeration;

import org.jetbrains.annotations.NotNull;

import java.util.Arrays;

/**
 * 全电登录方式
 *
 * @author Bobo
 * @create 2022/7/5 10:54
 * @since 1.0.0
 */
public enum AeLoginTypeEnum {
    CLIENT("client", "客户端登录"),
    SERVER("server", "服务端登录"),
    LE_QI("leqi", "乐企");

    private String type;
    private String text;

    AeLoginTypeEnum(String type, String text) {
        this.type = type;
        this.text = text;
    }

    public static AeLoginTypeEnum from(@NotNull String type) {

        return Arrays.stream(AeLoginTypeEnum.values())
                .filter(value -> type.equals(value.type))
                .findAny().orElse(null);
    }

    public String getType() {
        return type;
    }
}
