package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 全电销方基础信息消息
 * <p>
 * https://api-mock.xforceplus.com/project/141/interface/api/41432
 *
 * @author Bobo
 * @create 2022/8/23 11:57
 * @since 1.0.0
 */
public class AeSellerBasicInfoMessage {

    @Data
    public static class Request {

        /**
         * 税号
         **/
        private String taxNo;

        /**
         * 总授信额度(18,2)
         */
        private BigDecimal creditLines;

        /**
         * 可用授信额度(18,2)
         */
        private BigDecimal balanceCreditLines;

        /**
         * 纳税人类型
         **/
        private String taxpayerType;

        /**
         * 纳税人信用等级
         **/
        private String taxpayerCreditLevel;

        /**
         * 授信额度更新时间(格式:yyyy-MM-dd HH:mm:ss.SSS)
         **/
        private String creditLinesUpdateTime;

        /**
         * 销方银行信息列表
         */
        private List<SellerBank> sellerBankList;

    }

    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message = "成功";

        /**
         * 追踪码
         */
        private String traceId;

        /**
         * 结果
         **/
        private Result result;

    }

    @Data
    public static class Result {

        /**
         * 税号
         **/
        private String taxNo;

        /**
         * 总授信额度(18,2)
         */
        private BigDecimal creditLines;

        /**
         * 可用授信额度(18,2)
         */
        private BigDecimal balanceCreditLines;

        /**
         * 纳税人类型
         **/
        private String taxpayerType;

        /**
         * 纳税人信用等级
         **/
        private String taxpayerCreditLevel;

        /**
         * 授信额度更新时间(格式:yyyy-MM-dd HH:mm:ss.SSS)
         **/
        private String creditLinesUpdateTime;

        /**
         * 销方银行信息列表
         */
        private List<SellerBank> sellerBankList;
    }

    @Data
    public static class SellerBank {

        /**
         * 销方开户行 [80]
         **/
        private String sellerBankName;

        /**
         * 销方开户行账号 [40]
         **/
        private String sellerBankAccount;

    }
}
