package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

/**
 * 创建开票队列
 * <p>
 * https://api-mock.xforceplus.com/project/141/interface/api/41232
 */
public class PostCreateQueueMessage {

    @Data
    public static class Request {

        /**
         * 税号
         **/
        private String taxNo;

        /**
         * 公司名称
         **/
        private String companyName;

        /**
         * 开票人
         **/
        private String issuer;

        /**
         * 纳税人类型
         **/
        private String taxpayerType;

        /**
         * 纳税人信用等级
         **/
        private String taxpayerCreditLevel;

        /**
         * 手机号码
         **/
        private String phone;

        /**
         * 登录方式
         **/
        private String loginType;
    }

    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message = "成功";

        /**
         * 追踪码
         */
        private String traceId;

        /**
         * 结果
         **/
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 开票队列
             **/
            private String queueName;

        }
    }
}
