package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

/**
 * 红字信息表操作结果回调消息
 * <p>
 * https://xforceplus.yuque.com/dew9bm/yagacb/ls65dy
 */
@Data
public class PatchRedInfoTableFlowStatusResultMessage {

    @Data
    public static class Properties {

        /**
         * 业务编号
         */
        private String businessNo;

        /**
         * 调用方系统
         */
        private String fromSystem;

        /**
         * 租户id
         */
        private String tenantId;
    }

    /**
     * 错误码：成功：1，失败：其他编码
     **/
    private String code = "1";

    /**
     * 描述
     **/
    private String message;

    /**
     * 结果
     **/
    private Result result;

    @Data
    public static class Result {

        /**
         * 请求流水号
         **/
        private String taskId;

        /**
         * 红字信息表编号
         **/
        private String redLetterNumber;

        /**
         * 是否乐企标识
         */
        private Boolean isNatureSystemFlag;
    }
}
