package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

/**
 * 全电发票开具资质开通
 * <p>
 * 契约地址：https://api-mock.xforceplus.com/project/141/interface/api/38975
 */
public class PostQualificationMessage {

    @Data
    public static class Request {

        /**
         * 税号
         **/
        private String taxNo;

        /**
         * 公司名称
         */
        private String companyName;

        /**
         * 地区名称
         */
        private String areaName;
    }

    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message = "成功";

        /**
         * 追踪码
         */
        private String traceId;
    }
}
