package com.xforceplus.taxware.contract.allelectric.message.enumeration;

import com.google.common.collect.Lists;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 全电开票方式
 *
 * @author Bobo
 * @create 2023/5/8 20:54
 * @since 1.0.0
 */
public enum IssueTypeEnum {
    NS(1, "ns", "乐企"),
    DPPT(2, "dppt", "电票平台");

    private int code;
    private String type;
    private String text;

    IssueTypeEnum(int code, String type, String text) {
        this.code = code;
        this.type = type;
        this.text = text;
    }

    public static IssueTypeEnum fromType(String type) {
        return Arrays.stream(IssueTypeEnum.values())
                .filter(value -> value.type.equals(type))
                .findAny().orElse(null);
    }

    public static List<IssueTypeEnum> fromCode(Integer code) {
        if (code == null || code == 0) {
            return Lists.newArrayList();
        }

        return Arrays.stream(IssueTypeEnum.values())
                .filter(x -> (x.code & code) > 0)
                .collect(Collectors.toList());
    }

    public static List<IssueTypeEnum> fromTypeList(List<String> issueTypeList) {
        if (issueTypeList == null) {
            return Lists.newArrayList();
        }

        return issueTypeList.stream().map(IssueTypeEnum::fromType).collect(Collectors.toList());
    }

    public static int to(List<IssueTypeEnum> issueTypeEnumList) {
        int code = 0;
        if (issueTypeEnumList == null) {
            return code;
        }

        for (IssueTypeEnum issueTypeEnum : issueTypeEnumList) {
            code += issueTypeEnum.code;
        }
        return code;
    }

    public static List<String> toTypeList(List<IssueTypeEnum> issueTypeEnumList) {
        if (issueTypeEnumList == null) {
            return Lists.newArrayList();
        }

        return issueTypeEnumList.stream().map(IssueTypeEnum::getType).collect(Collectors.toList());
    }

    public String getType() {
        return type;
    }

    public int getCode() {
        return code;
    }

    public String getText() {
        return text;
    }
}
