package com.xforceplus.taxware.contract.allelectric.message;

import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulParameterDTO;
import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulResponseDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 企业授信额度查询接口
 */
public class GetEnterpriseCreditLimitMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Parameter extends BaseRestfulParameterDTO {

        /**
         * 税号
         **/
        private String taxCode;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseRestfulResponseDTO {

        /**
         * 结果
         **/
        private Result result;

        @Data
        public static class Result {

            /**
             * 授信额度信息列表
             **/
            private List<CreditLimit> creditLimitList;

            @Data
            public static class CreditLimit {

                /**
                 * 当前授信属期(格式：yyyyMM)
                 **/
                private String period;

                /**
                 * 授信额度
                 **/
                private BigDecimal creditLines;

                /**
                 * 已使用授信额度
                 **/
                private BigDecimal usedCreditLines;

                /**
                 * 授信余额
                 **/
                private BigDecimal balanceCreditLines;

                /**
                 * 授信终止日期（格式：yyyy-MM-dd HH:mm:ss）
                 **/
                private String creditLinesEndDate;

                /**
                 * 授信状态
                 * enable：启动
                 * disable：停用
                 **/
                private String creditLinesStatus;
            }
        }
    }
}
