package com.xforceplus.taxware.contract.allelectric.message;

import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulParameterDTO;
import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulResponseDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 企业全电发票服务开通查询接口
 */
public class GetEnterpriseServiceMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Parameter extends BaseRestfulParameterDTO {

        /**
         * 平台编号
         **/
        private String platformNo;

        /**
         * 税号
         **/
        private String taxCode;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseRestfulResponseDTO {

        /**
         * 查询结果
         **/
        private Result result;

        @Data
        public static class Result {

            /**
             * 开通状态
             * ON：已开通
             * OFF：未开通
             * READY：未开通，具体开通条件
             * MISSING-PLATFORM-NO：未开通，不具备开通条件，需要提前在税件维护平台编号
             * UNBOUNDED：未开通，不具备开通条件，需提前在局端做平台编号和纳税人绑定
             **/
            private String status;
        }
    }
}
