package com.xforceplus.taxware.contract.allelectric.message;

import com.xforceplus.taxware.contract.allelectric.message.common.OpenApiBaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author Thj
 * @createdAt: 2022/10/9 14:05
 * @Description: 全电获取下一张发票号码代码契约
 * https://api-mock.xforceplus.com/project/136/interface/api/42588
 */
public class GetNextInvoiceNoMessage {

    @Data
    public static class Request {
        private String taskId;
        private String sellerTaxNo;
        private String issuer;

        /**
         * cz - 全电纸普 sz - 全电纸专
         */
        private String invoiceType;
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends OpenApiBaseResponseDto {
        private Result result = new Result();

        @Data
        public static class Result {
            private String taskId;
        }
    }
}
