package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

/**
 * @author Thj
 * @createdAt: 2023/6/20 11:15
 * @Description:
 */
@Data
public class GetRedInvoiceFromRedLetterMessage {

    @Data
    public static class Request {

        /**
         * 流水号 [32]
         **/
        private String taskId;

        /**
         * 开票人
         */
        private String issuer;

        /**
         * 销方税号
         */
        private String sellerTaxNo;

        /**
         * 申请方身份(01 - 销方, 02 - 购方) [2]
         */
        private String applyIdentity;

        /**
         * 对方纳税人名称
         */
        private String taxPayerName;

        /**
         * 红字确认单编号
         */
        private String redLetterNumber;

        /**
         * 原蓝字发票开票日期
         * yyyyMMdd
         */
        private String dateIssued;

        /**
         * 红字确认单录入日期（yyyyMMdd）
         */
        private String redApplyDate;

        /**
         * 红字确认单Uuid
         */
        private String redLetterUuid;
    }

    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message;

        /**
         * 结果
         **/
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 流水号 [32]
             **/
            private String taskId;
        }
    }
}
