package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

/**
 * 全电服务端登录
 * <p>
 * 契约地址：https://api-mock.xforceplus.com/project/141/interface/api/41214
 *
 * @author Bobo
 * @create 2022/9/7 13:57
 * @since 1.0.0
 */
public class GetServerLoginMessage {

    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message = "成功";

        /**
         * 追踪码
         */
        private String traceId;

        /**
         * 结果
         **/
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 登录成功标识,true:成功（此时返回开票人） false:没有（此时返回二维码）
             **/
            private boolean loginSuccessfulFlag;

            /**
             * 公司名称（登录成功必然有值）
             */
            private String companyName;

            /**
             * 开票人（登录成功必然有值）
             */
            private String issuer;

            /**
             * 二维码
             **/
            private String qrCode;
        }
    }
}
