package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

/**
 * 红字信息表操作接口(异步)
 * <p>
 * https://api-mock.xforceplus.com/project/136/interface/api/38990
 */
public class PatchRedInfoTableFlowStatusMessage {

    @Data
    public static class Request {

        /**
         * 请求流水号 [50]
         **/
        private String taskId;

        /**
         * 开票人
         */
        private String issuer;

        /**
         * 是否乐企标识（不传默认为false，如果传为true，走乐企通道）
         */
        private Boolean isNaturalSystemFlag;

        /**
         * 红字信息编号 [20]
         **/
        private String redLetterNumber;

        /**
         * 确认方身份(01 - 销方, 02 - 购方) [2]
         **/
        private String confirmIdentity;

        /**
         * 确认状态(01-同意(暂不支持), 02-不同意(暂不支持), 03-撤销) [2]
         **/
        private String confirmStatus;

        /**
         * 红字申请日期（yyyyMMddHHmmss）
         */
        private String dateRedApplied;

        /**
         * 全电发票号码
         */
        private String invoiceNo;

        /**
         * 购方信息
         **/
        private BuyerInfo buyer;

        @Data
        public static class BuyerInfo {

            /**
             * 购方税号 [20]
             **/
            private String buyerTaxNo;

            /**
             * 购方名称 [180]
             **/
            private String buyerName;
        }

        /**
         * 销方信息
         **/
        private SellerInfo seller;

        @Data
        public static class SellerInfo {

            /**
             * 销方税号 [20]
             **/
            private String sellerTaxNo;

            /**
             * 销方名称 [180]
             **/
            private String sellerName;
        }
    }

    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message;

        /**
         * 结果
         **/
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 流水号 [32]
             **/
            private String taskId;
        }
    }
}
