package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 红字信息表申请结果回调消息
 * <p>
 * https://xforceplus.yuque.com/dew9bm/yagacb/hn55gs
 */
@Data
public class PostRedInfoTableResultMessage {

    @Data
    public static class Properties {

        /**
         * 业务编号
         */
        private String businessNo;

        /**
         * 调用方系统
         */
        private String fromSystem;

        /**
         * 租户id
         */
        private String tenantId;
    }

    /**
     * 错误码：成功：1，失败：其他编码
     **/
    private String code = "1";

    /**
     * 描述
     **/
    private String message;

    /**
     * 结果
     **/
    private Result result = new Result();

    @Data
    public static class Result {

        /**
         * 请求流水号
         **/
        private String taskId;

        /**
         * 红字信息表编号
         **/
        private String redLetterNumber;

        /**
         * 红字信息表状态
         * 01-无需确认
         * 02-销方录入待购方确认
         * 03-购方录入待销方确认
         */
        private String status;

        /**
         * 红字信息表申请日期时间
         * yyyyMMddHHmmss
         */
        private String dateRedApplied;

        /**
         * 是否乐企标识
         */
        private Boolean isNatureSystemFlag;

        /**
         * 红字确认单对应红票
         */
        private RedInvoice redInvoice;

        @Data
        public static class RedInvoice {

            /**
             * 发票号码
             */
            private String invoiceNo;

            /**
             * 发票类型
             * qc、qs、cz、sz
             */
            private String invoiceType;

            /**
             * 纸票发票代码（纸票红票有值）
             */
            private String paperInvoiceCode;

            /**
             * 纸票发票号码（纸票红票有值）
             */
            private String paperInvoiceNo;

            /**
             * 开票日期时间(yyyyMMddHHmmss)
             */
            private String dateIssued;

            /**
             * 二维码地址（纸票没有此字段）
             */
            private String qrCodeUrl;

            /**
             * 剩余开具额度
             */
            private BigDecimal creditLimit;

            /**
             * 剩余开具额度
             */
            private String remark;
        }
    }
}
