package com.xforceplus.taxware.contract.allelectric.message.enumeration;

import org.jetbrains.annotations.NotNull;

import java.util.Arrays;

/**
 * @author Thj
 * @createdAt: 2022/11/29 15:23
 * @Description: 全电优惠政策类型枚举
 */
public enum TaxIncentivesTypeEnum {
    SIMPLE_EXPROPRIATION("01", "简易征收"),
    TOMBARTHITE_PRODUCTION("02", "稀土产品"),
    DUTY_FREE("03", "免税"),
    NO_TAX("04", "不征税"),
    REFUND_AFTER_COLLECTION("05", "先征后退"),
    ONE_HUNDRED_PERCENT_REFUND_AFTER_COLLECTION("06", "100%先征后退"),
    FIFTY_PERCENT_REFUND_AFTER_COLLECTION("07", "50%先征后退"),
    THREE_PERCENT_SIMPLE_EXPROPRIATION("08", "按3%简易征收"),
    FIVE_PERCENT_SIMPLE_EXPROPRIATION("09", "按5%简易征收"),
    FIVE_PERCENT_SIMPLE_EXPROPRIATION_REDUCE_ONE_POINT_FIVE_PERCENT("10", "按5%简易征收减按1.5%计证"),
    THIRTY_PERCENT_IMMEDIATE_COLLECTION_REFUND("11", "即征即退30%"),
    FIFTY_PERCENT_IMMEDIATE_COLLECTION_REFUND("12", "即征即退50%"),
    SEVENTY_PERCENT_IMMEDIATE_COLLECTION_REFUND("13", "即征即退70%"),
    ONE_HUNDRED_PERCENT_IMMEDIATE_COLLECTION_REFUND("14", "即征即退100%"),
    EXCEED_MINUS_THREE_PERVENT_IMMEDIATE_COLLECTION_REFUND("15", "超税负3%即征即退"),
    EXCEED_MINUS_EIGHT_PERVENT_IMMEDIATE_COLLECTION_REFUND("16", "超税负8%即征即退"),
    EXCEED_MINUS_TWELVE_PERVENT_IMMEDIATE_COLLECTION_REFUND("17", "超税负12%即征即退"),
    EXCEED_MINUS_SIX_PERVENT_IMMEDIATE_COLLECTION_REFUND("18", "超税负6%即征即退"),
    ;

    private String code;
    private String name;

    TaxIncentivesTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String toCode() {
        return code;
    }

    public String toName() {
        return name;
    }

    public static TaxIncentivesTypeEnum fromCode(@NotNull String code) {

        return Arrays.stream(TaxIncentivesTypeEnum.values())
                .filter(taxIncentivesTypeEnum -> code.equals(taxIncentivesTypeEnum.toCode()))
                .findAny().orElse(null);
    }
}
