package com.xforceplus.taxware.contract.allelectric.message.enumeration;

import org.jetbrains.annotations.NotNull;

import java.util.Arrays;

/**
 * @author Thj
 * @createdAt: 2022/11/29 15:23
 * @Description: 全电即征即退类型枚举
 */
public enum VatRefundTypeEnum {
    SOFTWARE_PRODUCTION("1", "增值税即征即退-软件产品"),
    COMPREHENSIVE_UTILIZATION_OF_RESOURCES("2", "增值税即征即退-资源综合利用产品"),
    PIPELINE_TRANSPORTATION_SERVICES("3", "增值税即征即退-管道运输服务"),
    TANGIBLE_MOVABLE_PROPERTY_FINANCIAL_LEASING_SERVICE("4", "增值税即征即退-有形动产融资租赁服务"),
    TANGIBLE_MOVABLE_PROPERTY_FINANCING_SALE_AND_LEASEBACK_SERVICE("5", "增值税即征即退-有形动产融资性售后回租服务"),
    NEW_WALL_MATERIAL("6", "增值税即征即退-新型墙体材料"),
    WIND_POWER_PRODUCTS("7", "增值税即征即退-风力发电产品"),
    GUANGFU_POWER_PRODUCTS("8", "增值税即征即退-光伏发电产品"),
    ANIMATION_SOFTWARE_PRODUCTS("9", "增值税即征即退-动漫软件产品"),
    AIRCRAFT_MAINTENANCE_LABOR("10", "增值税即征即退-飞机维修劳务"),
    GOLD("11", "增值税即征即退-黄金"),
    PLATINUM("12", "增值税即征即退-铂金"),
    ;

    private String code;
    private String name;

    VatRefundTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String toCode() {
        return code;
    }

    public String toName() {
        return name;
    }

    public static VatRefundTypeEnum fromCode(@NotNull String code) {

        return Arrays.stream(VatRefundTypeEnum.values())
                .filter(vatRefundTypeEnum -> code.equals(vatRefundTypeEnum.toCode()))
                .findAny().orElse(null);
    }
}
