package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

import java.util.List;

/**
 * @author Thj
 * @createdAt: 2023/6/26 14:34
 * @Description:
 */
public class AeQueryInvoiceNoPidMessage {

    @Data
    public static class Response {

        /**
         * 返回码（TXWR000000为成功 其余为失败）
         */
        private String code = "TXWR000000";

        /**
         * 返回信息
         */
        private String message = "成功";

        /**
         * 结果
         **/
        private Result result;

        @Data
        public static class Result {

            /**
             * 发票号码和pid的对应关系
             **/
            private List<InvoiceNoPid> invoicePidList;
        }
    }

    @Data
    public static class InvoiceNoPid {
        private String invoiceNo;
        private String pid;
    }
}
