package com.xforceplus.taxware.contract.allelectric.message;

import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulParameterDTO;
import com.xforceplus.taxware.contract.allelectric.message.common.PageInfoResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.ArrayList;
import java.util.List;

/**
 * 计费服务查询
 * <p>
 * https://api-mock.xforceplus.com/project/141/interface/api/41448
 */
public class GetSupportServiceMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Parameter extends BaseRestfulParameterDTO {

        /**
         * 租户id
         */
        private String tenantId;

        /**
         * 税号
         */
        private String taxNo;

        /**
         * 服务名称(支持查询多个，以英文逗号分隔)
         */
        private String serviceNames;

        /**
         * 当前页码
         */
        private Integer pageNo = 1;

        /**
         * 每页数量
         */
        private Integer pageSize = 100;
    }

    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message = "成功";

        /**
         * 追踪码
         */
        private String traceId;

        /**
         * 结果
         */
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 租户列表
             */
            private List<TenantDto> tenantList = new ArrayList<>();

            /**
             * 分页信息
             */
            private PageInfoResponse pageInfo;

            @Data
            public static class TenantDto {

                /**
                 * 租户ID
                 */
                private String tenantId;

                /**
                 * 税号
                 */
                private String taxNo;

                /**
                 * 公司名称
                 */
                private String companyName;

                /**
                 * 服务列表
                 */
                private List<String> serviceNameList;

            }
        }

    }

}
