package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

import java.util.List;

/**
 * 【批量】全电发票开具资质查询
 * <p>
 * 契约地址：https://api-mock.xforceplus.com/project/141/interface/api/43968
 */
public class PostBatchQueryQualificationMessage {

    @Data
    public static class Request {
        private List<String> taxNoList;
    }

    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message = "成功";

        /**
         * 追踪码
         */
        private String traceId;

        /**
         * 结果
         **/
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 资质列表
             **/
            private List<Qualification> qualifications;

            @Data
            public static class Qualification {

                /**
                 * 税号
                 **/
                private String taxNo;

            }

        }
    }
}
