package com.xforceplus.taxware.contract.allelectric.message;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 红字信息表申请接口(异步)
 * <p>
 * https://api-mock.xforceplus.com/project/136/interface/api/38985
 */
public class PostRedInfoTableMessage {

    @Data
    public static class Request {

        /**
         * 流水号 [50]
         **/
        private String taskId;

        /**
         * 单据唯一号 [50]
         **/
        private String pid;

        /**
         * 开票人
         */
        private String issuer;

        /**
         * 是否乐企标识（不传默认为false，如果传为true，走乐企通道）
         */
        private Boolean isNaturalSystemFlag;

        /**
         * 申请方身份(01 - 销方, 02 - 购方) [2]
         **/
        private String applyIdentity;

        /**
         * 冲红原因（ 03 开票有误 04 应税服务中止 05 销售折让）[2]
         **/
        private String applyReason;

        /**
         * 价格方式(1-含税,0-不含税，默认: 不含税)
         */
        private String pricingMethod = "0";

        /**
         * 开票控制项
         */
        private RedControl control;

        @Data
        public static class RedControl {

            /**
             * 版式文件控制项
             */
            private Integer voucherControl;
        }

        /**
         * 购方信息
         **/
        private BuyerInfo buyer;

        @Data
        public static class BuyerInfo {

            /**
             * 购方税号 [20]
             **/
            private String buyerTaxNo;

            /**
             * 购方名称 [180]
             **/
            private String buyerName;
        }

        /**
         * 销方信息
         **/
        private SellerInfo seller;

        @Data
        public static class SellerInfo {

            /**
             * 销方税号 [20]
             **/
            private String sellerTaxNo;

            /**
             * 销方名称 [180]
             **/
            private String sellerName;
        }

        /**
         * 原蓝票信息
         **/
        private InvoiceInfo originalInvoice;

        @Data
        public static class InvoiceInfo {

            /**
             * 原蓝票发票号码 [20]
             **/
            private String invoiceNo;

            /**
             * 纸票发票号码
             */
            private String paperInvoiceNo;

            /**
             * 纸票发票代码
             */
            private String paperInvoiceCode;

            /**
             * 原蓝票发票类型：qc - 电普, qs - 电专 [2]
             **/
            private String invoiceType;

            /**
             * 原蓝票发票金额 [18,2]
             **/
            private BigDecimal amountWithoutTax;

            /**
             * 原蓝票税额 [18,2]
             **/
            private BigDecimal taxAmount;

            /**
             * 原蓝票含税金额 [18,2]
             */
            private BigDecimal amountWithTax;

            /**
             * 原蓝票开票日期
             */
            private String invoiceDateTime;

            /**
             * 全电特定要素
             */
            private String invoiceStyleType;
        }

        /**
         * 红冲金额 [18,2]
         **/
        private BigDecimal redAmount;

        /**
         * 红冲税额 [18,2]
         **/
        private BigDecimal redTaxAmount;

        /**
         * 红冲含税金额
         */
        private BigDecimal redAmountWithTax;

        /**
         * 明细列表
         **/
        private List<Details> details;

        @Data
        public static class Details {

            /**
             * 原蓝票明细序号
             */
            private Integer originInvoiceRowNum;

            /**
             * 明细金额信息
             **/
            private AmountInfo detailAmount;

            @Data
            public static class AmountInfo {

                /**
                 * 不含税金额 [18,2]
                 **/
                private BigDecimal amountWithoutTax;

                /**
                 * 数量 [27,15]
                 **/
                private BigDecimal quantity;

                /**
                 * 税额 [18,2]
                 **/
                private BigDecimal taxAmount;

                /**
                 * 含税金额 [18,2]
                 */
                private BigDecimal amountWithTax;

                /**
                 * 单价 [27,15]
                 **/
                private BigDecimal unitPrice;
            }

            /**
             * 商品信息
             **/
            private ItemInfo item;

            @Data
            public static class ItemInfo {

                /**
                 * 商品名称 [92]
                 **/
                private String itemName;

                /**
                 * 规格型号 [40]
                 **/
                private String specifications;

                /**
                 * 单位 [22]
                 **/
                private String unit;
            }

            /**
             * 税收信息
             **/
            private TaxInfo tax;

            @Data
            public static class TaxInfo {

                /**
                 * 税率 [18,2]
                 **/
                private BigDecimal taxRate;

                /**
                 * 税收分类编码 [20]
                 **/
                private String goodsTaxNo;
            }
        }
    }

    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message;

        /**
         * 结果
         **/
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 流水号 [32]
             **/
            private String taskId;
        }
    }
}
