package com.xforceplus.taxware.contract.allelectric.message;

import com.xforceplus.taxware.contract.allelectric.message.common.OpenApiBaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 数电红字确认单查询
 *
 * @author zhouwen
 * @date 2023-07-18
 */
public class PostRedLetterQueryMessage {

    @Data
    public static class Request {

        /**
         * 请求流水号
         */
        private String taskId;

        /**
         * 查询税号
         */
        private String taxNo;

        /**
         * 同步身份: 01 - 销方, 02 - 购方
         */
        private String downloadIdentity;

        /**
         * 红字确认单编号
         */
        private String redLetterNumber;

        /**
         * 对方纳税人名称
         */
        private String taxPayerName;

        /**
         * 申请起始日期, 格式: yyyy-MM-dd
         */
        private String startApplyDate;

        /**
         * 申请截止日期, 格式: yyyy-MM-dd
         */
        private String endApplyDate;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends OpenApiBaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 请求流水号
             */
            private String taskId;
        }
    }
}